/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.list.entries;

import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.component.list.DisplayList;
import com.libraries.rabbit.gui.component.list.entries.ListEntry;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class ButtonEntry
extends Button
implements ListEntry {
    public ButtonEntry(String text) {
        super(0, 0, 0, 0, text);
    }

    public ButtonEntry(String text, Button.ButtonClickListener listener) {
        super(0, 0, 0, 0, text);
        super.setClickListener(listener);
    }

    @Override
    public void onClick(DisplayList list, int mouseX, int mouseY, int mouseButtonIndex) {
        if (this.isEnabled) {
            if (super.getClickListener() != null) {
                super.onMouseClicked(mouseX, mouseY, mouseButtonIndex, false);
            }
        } else {
            this.setSelected(false);
        }
    }

    @Override
    public void onDraw(DisplayList list, int posX, int posY, int width, int height, int mouseX, int mouseY) {
        if (this.getX() != posX) {
            this.setX(posX);
        }
        if (this.getY() != posY) {
            this.setY(posY);
        }
        if (this.getWidth() != width) {
            this.setWidth(width);
        }
        if (this.getHeight() != height) {
            this.setHeight(height);
        }
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            this.prepareRender();
            if (!this.isEnabled()) {
                this.drawButton(0);
            } else if (this.isButtonUnderMouse(mouseX, mouseY)) {
                this.drawButton(2);
                if (this.drawHoverText) {
                    this.verifyHoverText(mouseX, mouseY);
                    if (this.drawToLeft) {
                        int tlineWidth = 0;
                        for (String line : this.hoverText) {
                            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
                        }
                        Renderer.drawHoveringTextInScissoredArea(this.hoverText, mouseX - tlineWidth - 20, mouseY);
                    } else {
                        Renderer.drawHoveringTextInScissoredArea(this.hoverText, mouseX, mouseY);
                    }
                }
            } else {
                this.drawButton(1);
            }
            TextRenderer.renderString(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2 - 4, this.getText(), TextAlignment.CENTER);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public ButtonEntry setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }
}

