/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.list.entries;

import com.libraries.rabbit.gui.component.list.DisplayList;
import com.libraries.rabbit.gui.component.list.entries.SelectListEntry;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.awt.Color;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SelectElementEntry<T>
extends SelectListEntry {
    @LayoutComponent
    protected boolean isEnabled = true;
    private final String title;
    private final T entryValue;
    @LayoutComponent
    protected TextAlignment align = TextAlignment.CENTER;
    @LayoutComponent
    private Color color;
    private OnClickListener listener;

    public SelectElementEntry(T value, String title) {
        this(value, title, Color.WHITE, null);
    }

    public SelectElementEntry(T value, String title, Color color) {
        this(value, title, color, null);
    }

    public SelectElementEntry(T value, String title, Color color, OnClickListener listener) {
        this.entryValue = value;
        this.title = title;
        this.listener = listener;
        this.color = color;
    }

    public SelectElementEntry(T value, String title, OnClickListener listener) {
        this(value, title, Color.WHITE, listener);
    }

    public TextAlignment getAlignment() {
        return this.align;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public T getValue() {
        return this.entryValue;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void onClick(DisplayList list, int mouseX, int mouseY, int mouseButtonIndex) {
        if (this.isEnabled) {
            super.onClick(list, mouseX, mouseY, mouseButtonIndex);
            if (this.listener != null) {
                this.listener.onClick(this, list, mouseX, mouseY);
            }
        } else {
            this.setSelected(false);
        }
    }

    @Override
    public void onDraw(DisplayList list, int posX, int posY, int width, int height, int mouseX, int mouseY) {
        super.onDraw(list, posX, posY, width, height, mouseX, mouseY);
        if (this.isEnabled()) {
            if (this.align == TextAlignment.CENTER) {
                TextRenderer.renderString(posX + width / 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            } else if (this.align == TextAlignment.LEFT) {
                TextRenderer.renderString(posX + 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            } else if (this.align == TextAlignment.RIGHT) {
                TextRenderer.renderString(posX + width - 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            }
        } else if (this.align == TextAlignment.CENTER) {
            TextRenderer.renderString(posX + width / 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        } else if (this.align == TextAlignment.LEFT) {
            TextRenderer.renderString(posX + 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        } else if (this.align == TextAlignment.RIGHT) {
            TextRenderer.renderString(posX + width - 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        }
    }

    @Override
    public void onUpdate() {
    }

    public SelectElementEntry<T> setAlignment(TextAlignment align) {
        this.align = align;
        return this;
    }

    @Override
    public SelectElementEntry<T> setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public static interface OnClickListener {
        public void onClick(SelectElementEntry var1, DisplayList var2, int var3, int var4);
    }
}

