/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.list.entries;

import com.libraries.rabbit.gui.component.list.DisplayList;
import com.libraries.rabbit.gui.component.list.entries.SelectListEntry;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.awt.Color;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SelectStringEntry
extends SelectListEntry {
    @LayoutComponent
    protected boolean isEnabled = true;
    private final String title;
    @LayoutComponent
    private Color color;
    @LayoutComponent
    protected TextAlignment align = TextAlignment.CENTER;
    private OnClickListener listener;

    public SelectStringEntry(String title) {
        this(title, Color.WHITE, null);
    }

    public SelectStringEntry(String title, Color color) {
        this(title, color, null);
    }

    public SelectStringEntry(String title, Color color, OnClickListener listener) {
        this.title = title;
        this.listener = listener;
        this.color = color;
    }

    public SelectStringEntry(String title, OnClickListener listener) {
        this(title, Color.WHITE, listener);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getValue() {
        return this.title;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void onClick(DisplayList list, int mouseX, int mouseY, int mouseButtonIndex) {
        if (this.isEnabled) {
            super.onClick(list, mouseX, mouseY, mouseButtonIndex);
            if (this.listener != null) {
                this.listener.onClick(this, list, mouseX, mouseY);
            }
        } else {
            this.setSelected(false);
        }
    }

    @Override
    public void onDraw(DisplayList list, int posX, int posY, int width, int height, int mouseX, int mouseY) {
        super.onDraw(list, posX, posY, width, height, mouseX, mouseY);
        if (this.isEnabled()) {
            if (this.align == TextAlignment.CENTER) {
                TextRenderer.renderString(posX + width / 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            } else if (this.align == TextAlignment.LEFT) {
                TextRenderer.renderString(posX + 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            } else if (this.align == TextAlignment.RIGHT) {
                TextRenderer.renderString(posX + width - 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            }
        } else if (this.align == TextAlignment.CENTER) {
            TextRenderer.renderString(posX + width / 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        } else if (this.align == TextAlignment.LEFT) {
            TextRenderer.renderString(posX + 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        } else if (this.align == TextAlignment.RIGHT) {
            TextRenderer.renderString(posX + width - 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public SelectStringEntry setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public SelectStringEntry setTextAlignment(TextAlignment align) {
        this.align = align;
        return this;
    }

    public static interface OnClickListener {
        public void onClick(SelectStringEntry var1, DisplayList var2, int var3, int var4);
    }
}

