/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.list.entries;

import com.libraries.rabbit.gui.component.list.DisplayList;
import com.libraries.rabbit.gui.component.list.entries.ListEntry;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.awt.Color;

public class StringEntry
implements ListEntry {
    @LayoutComponent
    protected boolean isEnabled = true;
    @LayoutComponent
    protected TextAlignment align = TextAlignment.CENTER;
    private final String title;

    public StringEntry(String title) {
        this.title = title;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void onClick(DisplayList list, int mouseX, int mouseY, int mouseButtonIndex) {
    }

    @Override
    public void onDraw(DisplayList list, int posX, int posY, int width, int height, int mouseX, int mouseY) {
        if (this.isEnabled()) {
            if (this.align == TextAlignment.CENTER) {
                TextRenderer.renderString(posX + width / 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            } else if (this.align == TextAlignment.LEFT) {
                TextRenderer.renderString(posX + 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            } else if (this.align == TextAlignment.RIGHT) {
                TextRenderer.renderString(posX + width - 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), this.align);
            }
        } else if (this.align == TextAlignment.CENTER) {
            TextRenderer.renderString(posX + width / 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        } else if (this.align == TextAlignment.LEFT) {
            TextRenderer.renderString(posX + 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        } else if (this.align == TextAlignment.RIGHT) {
            TextRenderer.renderString(posX + width - 2, posY + height / 2 - 5, TextRenderer.getFontRenderer().func_78269_a(this.title, width), Color.gray, this.align);
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public StringEntry setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public StringEntry setTextAlignment(TextAlignment align) {
        this.align = align;
        return this;
    }
}

