/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.render;

import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import com.libraries.rabbit.gui.utils.ColourHelper;
import java.awt.Color;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Renderer {
    public static void drawContinuousTexturedBox(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        Renderer.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder);
        Renderer.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder);
        Renderer.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder);
        Renderer.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder);
        IntStream.range(0, xPasses + (remainderWidth > 0 ? 1 : 0)).forEach(i -> {
            Renderer.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder);
            Renderer.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder);
            IntStream.range(0, yPasses + (remainderHeight > 0 ? 1 : 0)).forEach(j -> Renderer.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight));
        });
        IntStream.range(0, yPasses + (remainderHeight > 0 ? 1 : 0)).forEach(j -> {
            Renderer.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight);
            Renderer.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight);
        });
        GlStateManager.func_179084_k();
    }

    public static void drawFilledArc(int xCenter, int yCenter, int radius, double startDegrees, double finishDegrees, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        ColourHelper.glColorRGB(color);
        GL11.glBegin((int)6);
        GL11.glVertex2d((double)xCenter, (double)yCenter);
        for (double i = startDegrees; i <= finishDegrees; i += 0.05) {
            double theta = Math.PI * 2 * i / 360.0;
            double dotX = (double)xCenter + Math.sin(theta) * (double)radius;
            double dotY = (double)yCenter + Math.cos(theta) * (double)radius;
            GL11.glVertex2d((double)dotX, (double)dotY);
        }
        GL11.glEnd();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void drawGradient(int xTop, int yTop, int xBot, int yBot, int firstColor, int secondColor) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        GL11.glBegin((int)7);
        ColourHelper.glColorRGB(firstColor);
        GL11.glVertex2d((double)xBot, (double)yTop);
        GL11.glVertex2d((double)xTop, (double)yTop);
        ColourHelper.glColorRGB(secondColor);
        GL11.glVertex2d((double)xTop, (double)yBot);
        GL11.glVertex2d((double)xBot, (double)yBot);
        GL11.glEnd();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    public static void drawHorizontalLine(int startX, int endX, int y, int color) {
        if (endX < startX) {
            int i1 = startX;
            startX = endX;
            endX = i1;
        }
        Renderer.drawRect(startX, y, endX + 1, y + 1, color);
    }

    public static void drawHoveringText(List<String> content, int xPos, int yPos) {
        if (!content.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
            int width = 0;
            for (String line : content) {
                int lineWidth = TextRenderer.getFontRenderer().func_78256_a(line);
                width = Math.max(width, lineWidth);
            }
            int x = xPos + 12;
            int y = yPos - 12;
            int additional = 8;
            if (content.size() > 1) {
                additional += 2 + (content.size() - 1) * 10;
            }
            int firstColor = -267386864;
            int secondColor = 0x505000FF;
            Renderer.drawGradient(x - 3, y - 4, x + width + 3, y - 3, firstColor, firstColor);
            Renderer.drawGradient(x - 3, y + additional + 3, x + width + 3, y + additional + 4, firstColor, firstColor);
            Renderer.drawGradient(x - 3, y - 3, x + width + 3, y + additional + 3, firstColor, firstColor);
            Renderer.drawGradient(x - 4, y - 3, x - 3, y + additional + 3, firstColor, firstColor);
            Renderer.drawGradient(x + width + 3, y - 3, x + width + 4, y + additional + 3, firstColor, firstColor);
            int l1 = (secondColor & 0xFEFEFE) >> 1 | secondColor & 0xFF000000;
            Renderer.drawGradient(x - 3, y - 3 + 1, x - 3 + 1, y + additional + 3 - 1, secondColor, l1);
            Renderer.drawGradient(x + width + 2, y - 3 + 1, x + width + 3, y + additional + 3 - 1, secondColor, l1);
            Renderer.drawGradient(x - 3, y - 3, x + width + 3, y - 3 + 1, secondColor, secondColor);
            Renderer.drawGradient(x - 3, y + additional + 2, x + width + 3, y + additional + 3, l1, l1);
            for (int i = 0; i < content.size(); ++i) {
                String line = content.get(i);
                TextRenderer.renderString(x, y, line, Color.white, true, TextAlignment.LEFT);
                if (i == 0) {
                    y += 2;
                }
                y += 10;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public static void drawHoveringTextInScissoredArea(List<String> content, int xPos, int yPos) {
        if (!content.isEmpty()) {
            GlStateManager.func_179094_E();
            GL11.glDisable((int)3089);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            int width = 0;
            for (String line : content) {
                int lineWidth = TextRenderer.getFontRenderer().func_78256_a(line);
                width = Math.max(width, lineWidth);
            }
            int x = xPos + 12;
            int y = yPos - 12;
            int additional = 8;
            if (content.size() > 1) {
                additional += 2 + (content.size() - 1) * 10;
            }
            int firstColor = -267386864;
            int secondColor = 0x505000FF;
            Renderer.drawGradient(x - 3, y - 4, x + width + 3, y - 3, firstColor, firstColor);
            Renderer.drawGradient(x - 3, y + additional + 3, x + width + 3, y + additional + 4, firstColor, firstColor);
            Renderer.drawGradient(x - 3, y - 3, x + width + 3, y + additional + 3, firstColor, firstColor);
            Renderer.drawGradient(x - 4, y - 3, x - 3, y + additional + 3, firstColor, firstColor);
            Renderer.drawGradient(x + width + 3, y - 3, x + width + 4, y + additional + 3, firstColor, firstColor);
            int l1 = (secondColor & 0xFEFEFE) >> 1 | secondColor & 0xFF000000;
            Renderer.drawGradient(x - 3, y - 3 + 1, x - 3 + 1, y + additional + 3 - 1, secondColor, l1);
            Renderer.drawGradient(x + width + 2, y - 3 + 1, x + width + 3, y + additional + 3 - 1, secondColor, l1);
            Renderer.drawGradient(x - 3, y - 3, x + width + 3, y - 3 + 1, secondColor, secondColor);
            Renderer.drawGradient(x - 3, y + additional + 2, x + width + 3, y + additional + 3, l1, l1);
            for (int i = 0; i < content.size(); ++i) {
                String line = content.get(i);
                TextRenderer.renderString(x, y, line, Color.white, true, TextAlignment.LEFT);
                if (i == 0) {
                    y += 2;
                }
                y += 10;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glEnable((int)3089);
            GlStateManager.func_179121_F();
        }
    }

    public static void drawItemTooltip(ItemStack stack, int xPos, int yPos) {
        List content = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
        for (int i = 0; i < content.size(); ++i) {
            if (i == 0) {
                content.set(i, stack.func_77953_t().field_77937_e + (String)content.get(i));
                continue;
            }
            content.set(i, TextFormatting.GRAY + (String)content.get(i));
        }
        Renderer.drawHoveringText(content, xPos, yPos);
    }

    public static void drawLine(int fromX, int fromY, int toX, int toY, Color color, float width) {
        GlStateManager.func_179094_E();
        ColourHelper.glColorAWT(color);
        GlStateManager.func_179090_x();
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)3);
        GL11.glVertex2i((int)fromX, (int)fromY);
        GL11.glVertex2i((int)toX, (int)toY);
        GL11.glEnd();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void drawLine(int fromX, int fromY, int toX, int toY, int color, float width) {
        GlStateManager.func_179094_E();
        ColourHelper.glColorRGB(color);
        GlStateManager.func_179090_x();
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)3);
        GL11.glVertex2i((int)fromX, (int)fromY);
        GL11.glVertex2i((int)toX, (int)toY);
        GL11.glEnd();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, int width, int height, float u, float v, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawRect(int xTop, int yTop, int xBot, int yBot, int color) {
        int temp;
        if (xTop < xBot) {
            temp = xTop;
            xTop = xBot;
            xBot = temp;
        }
        if (yTop < yBot) {
            temp = yTop;
            yTop = yBot;
            yBot = temp;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        ColourHelper.glColorRGB(color);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)xTop, (double)yBot, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xBot, (double)yBot, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xBot, (double)yTop, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xTop, (double)yTop, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawRectWithSpecialGL(int xTop, int yTop, int xBot, int yBot, int color, Runnable specialGL) {
        int temp;
        if (xTop < xBot) {
            temp = xTop;
            xTop = xBot;
            xBot = temp;
        }
        if (yTop < yBot) {
            temp = yTop;
            yTop = yBot;
            yBot = temp;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        specialGL.run();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        ColourHelper.glColorRGB(color);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)xTop, (double)yBot, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xBot, (double)yBot, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xBot, (double)yTop, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xTop, (double)yTop, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawScaledTexturedRect(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawScaledTexturedRect(int x, int y, int z, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int posX, int posY, int uPos, int vPos, int width, int height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(posX + 0), (double)(posY + height), 0.0).func_187315_a((double)((float)(uPos + 0) * f), (double)((float)(vPos + height) * f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(posX + width), (double)(posY + height), 0.0).func_187315_a((double)((float)(uPos + width) * f), (double)((float)(vPos + height) * f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(posX + width), (double)(posY + 0), 0.0).func_187315_a((double)((float)(uPos + width) * f), (double)((float)(vPos + 0) * f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(posX + 0), (double)(posY + 0), 0.0).func_187315_a((double)((float)(uPos + 0) * f), (double)((float)(vPos + 0) * f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + height), 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + width), (double)(yCoord + height), 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + width), (double)(yCoord + 0), 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTriangle(int leftX, int leftY, int topX, int topY, int rightX, int rightY, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GL11.glBlendFunc((int)770, (int)771);
        ColourHelper.glColorRGB(color);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)topX, (double)topY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)leftX, (double)leftY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)rightX, (double)rightY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void drawVerticalLine(int x, int startY, int endY, int color) {
        if (endY < startY) {
            int i1 = startY;
            startY = endY;
            endY = i1;
        }
        Renderer.drawRect(x, startY + 1, x + 1, endY, color);
    }

    public static TextureAtlasSprite getIcon(Block block) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176223_P());
    }

    public static RenderItem getRenderItem() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    public static void renderChatBubble(int xPos, int yPos, int width, int height, List<String> lines) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        int black = -16777216;
        int white = -1140850689;
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        Renderer.drawRect(xPos - 2, yPos - 2, xPos + width + 2, yPos + height + 1, white);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.1);
        Renderer.drawRect(xPos - 1, yPos - 3, xPos + width + 1, yPos + height - 2, black);
        Renderer.drawRect(xPos - 1, yPos + 2, xPos + width - 1, yPos + height + 1, black);
        Renderer.drawRect(xPos + 3, yPos + 2, xPos + width + 1, yPos + height + 1, black);
        Renderer.drawRect(xPos - 3, yPos - 1, xPos + width - 2, yPos + height, black);
        Renderer.drawRect(xPos + 3, yPos - 1, xPos + width + 2, yPos + height, black);
        Renderer.drawRect(xPos - 2, yPos - 2, xPos + width - 1, yPos + height - 1, black);
        Renderer.drawRect(xPos + 2, yPos - 2, xPos + width + 1, yPos + height - 1, black);
        Renderer.drawRect(xPos - 2, yPos + 1, xPos + width - 1, yPos + height, black);
        Renderer.drawRect(xPos + 2, yPos + 1, xPos + width + 1, yPos + height, black);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
        Renderer.drawRect(xPos, yPos + 1, xPos + width + 3, yPos + height + 4, white);
        Renderer.drawRect(xPos - 1, yPos + 4, xPos + width + 1, yPos + height + 5, white);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.1);
        Renderer.drawRect(xPos - 1, yPos + 1, xPos + width, yPos + height + 4, black);
        Renderer.drawRect(xPos + 3, yPos + 1, xPos + width + 4, yPos + height + 3, black);
        Renderer.drawRect(xPos + 2, yPos + 3, xPos + width + 3, yPos + height + 4, black);
        Renderer.drawRect(xPos + 1, yPos + 4, xPos + width + 2, yPos + height + 5, black);
        Renderer.drawRect(xPos - 2, yPos + 4, xPos + width - 1, yPos + height + 5, black);
        Renderer.drawRect(xPos - 2, yPos + 5, xPos + width + 1, yPos + height + 6, black);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        int index = 0;
        for (String message : lines) {
            Minecraft.func_71410_x().field_71466_p.func_175065_a(message, 5.0f + (float)xPos, (float)(5 + yPos + index * font.field_78288_b), black, false);
            ++index;
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void vdrawCenteredString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_175063_a(text, (float)(x - fontRendererIn.func_78256_a(text) / 2), (float)y, color);
    }

    protected static void vdrawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, int z) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)z).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)z).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)z).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)z).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    protected static void vdrawHorizontalLine(int startX, int endX, int y, int color) {
        if (endX < startX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        Renderer.drawRect(startX, y, endX + 1, y + 1, color);
    }

    public static void vdrawModalRectWithCustomSizedTexture(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void vdrawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void vdrawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)uWidth) * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)uWidth) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void vdrawString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_175063_a(text, (float)x, (float)y, color);
    }

    public static void vdrawTexturedModalRect(float xCoord, float yCoord, int zCoord, int minU, int minV, int maxU, int maxV) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + (float)maxV), (double)zCoord).func_187315_a((double)((float)(minU + 0) * f), (double)((float)(minV + maxV) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + (float)maxV), (double)zCoord).func_187315_a((double)((float)(minU + maxU) * f), (double)((float)(minV + maxV) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + 0.0f), (double)zCoord).func_187315_a((double)((float)(minU + maxU) * f), (double)((float)(minV + 0) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)zCoord).func_187315_a((double)((float)(minU + 0) * f), (double)((float)(minV + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void vdrawTexturedModalRect(int x, int y, int z, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), (double)z).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), (double)z).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), (double)z).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void vdrawTexturedModalRect(int xCoord, int yCoord, int zCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), (double)zCoord).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)zCoord).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), (double)zCoord).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), (double)zCoord).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    protected static void vdrawVerticalLine(int x, int startY, int endY, int color) {
        if (endY < startY) {
            int i = startY;
            startY = endY;
            endY = i;
        }
        Renderer.drawRect(x, startY + 1, x + 1, endY, color);
    }
}

