/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.render;

import com.libraries.rabbit.gui.render.TextAlignment;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextRenderer {
    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static int renderString(int xPos, int yPos, String text) {
        return TextRenderer.renderString(xPos, yPos, text, Color.white, TextAlignment.LEFT);
    }

    public static int renderString(int xPos, int yPos, String text, Color color) {
        return TextRenderer.renderString(xPos, yPos, text, color, false, TextAlignment.LEFT);
    }

    public static int renderString(int xPos, int yPos, String text, Color color, boolean shadow, TextAlignment align) {
        switch (align) {
            case LEFT: {
                return TextRenderer.getFontRenderer().func_175065_a(text, (float)xPos, (float)yPos, color.getRGB(), shadow);
            }
            case CENTER: {
                return TextRenderer.getFontRenderer().func_175065_a(text, (float)(xPos - TextRenderer.getFontRenderer().func_78256_a(text) / 2), (float)yPos, color.getRGB(), shadow);
            }
            case RIGHT: {
                return TextRenderer.getFontRenderer().func_175065_a(text, (float)(xPos - TextRenderer.getFontRenderer().func_78256_a(text)), (float)yPos, color.getRGB(), shadow);
            }
        }
        return -1;
    }

    public static int renderString(int xPos, int yPos, String text, Color color, TextAlignment align) {
        return TextRenderer.renderString(xPos, yPos, text, color, false, align);
    }

    public static int renderString(int xPos, int yPos, String text, TextAlignment align) {
        return TextRenderer.renderString(xPos, yPos, text, Color.white, align);
    }

    public static int renderUnicodeString(int xPos, int yPos, String text, Color color, TextAlignment align) {
        TextRenderer.getFontRenderer().func_78264_a(true);
        int retVal = TextRenderer.renderString(xPos, yPos, text, color, false, align);
        TextRenderer.getFontRenderer().func_78264_a(false);
        return retVal;
    }

    public static int renderUnicodeString(int xPos, int yPos, String text, TextAlignment align) {
        TextRenderer.getFontRenderer().func_78264_a(true);
        int retVal = TextRenderer.renderString(xPos, yPos, text, Color.white, align);
        TextRenderer.getFontRenderer().func_78264_a(false);
        return retVal;
    }
}

