/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.show;

import com.libraries.rabbit.gui.base.IStage;
import com.libraries.rabbit.gui.base.Stage;
import com.libraries.rabbit.gui.base.WidgetContainer;
import com.libraries.rabbit.gui.component.IBackground;
import com.libraries.rabbit.gui.component.IGui;
import com.libraries.rabbit.gui.show.IShow;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.lwjgl.opengl.Display;

@SideOnly(value=Side.CLIENT)
public abstract class Show
implements IShow,
WidgetContainer {
    protected List<IGui> components = new ArrayList<IGui>();
    protected String id;
    protected int width;
    protected int height;
    protected IStage stage;
    protected String title;
    private IBackground background;
    private boolean initialized = false;

    @Override
    public IBackground getBackground() {
        return this.background;
    }

    @Override
    public List<IGui> getComponentsList() {
        return this.components;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public WidgetContainer getParent() {
        return null;
    }

    @Override
    public IStage getStage() {
        return this.stage;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean hasBeenInitialized() {
        return this.initialized;
    }

    @Override
    public void onClose() {
        this.getComponentsList().forEach(com -> com.onClose());
        Display.setTitle((String)("Minecraft " + Minecraft.func_71410_x().func_175600_c()));
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        if (this.getBackground() != null) {
            this.getBackground().onDraw(this.width, this.height, mouseX, mouseY, partialTicks);
        }
        ListIterator<IGui> it = this.getComponentsList().listIterator(this.getComponentsList().size());
        while (it.hasPrevious()) {
            it.previous().onDraw(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void onInit() {
        if (!StringUtils.func_151246_b((String)this.title)) {
            this.updateDisplayTitle();
        }
        this.initialized = true;
    }

    @Override
    public void onKeyTyped(char typedChar, int typedIndex) {
        this.getComponentsList().forEach(com -> com.onKeyTyped(typedChar, typedIndex));
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked = false;
        for (IGui com : this.getComponentsList()) {
            clicked = com.onMouseClicked(posX, posY, mouseButtonIndex, clicked) || clicked;
        }
        return clicked;
    }

    @Override
    public void onMouseInput() {
        this.getComponentsList().forEach(com -> com.onMouseInput());
    }

    @Override
    public void onMouseRelease(int mouseX, int mouseY) {
        this.getComponentsList().forEach(com -> com.onMouseRelease(mouseX, mouseY));
    }

    @Override
    public void onRegistered(WidgetContainer pane) {
        Validate.isTrue((boolean)(pane instanceof Stage), (String)"Provided WidgetContainer should be Stage", (Object[])new Object[0]);
        this.setStage((Stage)((Object)pane));
    }

    @Override
    public void onUpdate() {
        this.getComponentsList().forEach(com -> com.onUpdate());
    }

    @Override
    public void registerComponent(IGui component) {
        this.components.add(component);
        if (component instanceof WidgetContainer) {
            ((WidgetContainer)((Object)component)).onRegistered(this);
        }
    }

    @Override
    public void setBackground(IBackground background) {
        this.background = background;
    }

    @Override
    public <T> IGui setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @Deprecated
    public final void setParent(WidgetContainer c) {
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void setStage(IStage stage) {
        this.stage = stage;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.updateDisplayTitle();
    }

    @Override
    public void setup() {
        this.getComponentsList().forEach(com -> com.setup());
    }

    private void updateDisplayTitle() {
        Display.setTitle((String)("Minecraft " + Minecraft.func_71410_x().func_175600_c() + " - " + this.title));
    }
}

