/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.utils;

import java.awt.Color;
import net.minecraft.client.renderer.GlStateManager;

public class ColourHelper {
    public static int AWTColor2RGBInt(Color color) {
        return ColourHelper.RGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int blend(int ... colours) {
        if (colours.length < 1) {
            throw new IllegalArgumentException();
        }
        int[] alphas = new int[colours.length];
        int[] reds = new int[colours.length];
        int[] greens = new int[colours.length];
        int[] blues = new int[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            alphas[i] = colours[i] >> 24 & 0xFF;
            reds[i] = (colours[i] & 0xFF0000) >> 16;
            greens[i] = (colours[i] & 0xFF00) >> 8;
            blues[i] = colours[i] & 0xFF;
        }
        float b = 0.0f;
        float g = 0.0f;
        float r = 0.0f;
        float a = 0.0f;
        float ratio = 1.0f / (float)colours.length;
        for (int alpha : alphas) {
            a += (float)alpha * ratio;
        }
        for (int red : reds) {
            r += (float)red * ratio;
        }
        for (int green : greens) {
            g += (float)green * ratio;
        }
        for (int blue : blues) {
            b += (float)blue * ratio;
        }
        return (int)a << 24 | (int)r << 16 | (int)g << 8 | (int)b;
    }

    public static int blendWithGreyScale(int colour, float greyScale) {
        return ColourHelper.blend(colour, ColourHelper.RGB(greyScale, greyScale, greyScale));
    }

    public static int getRainbowColour(float freqR, float freqG, float freqB, float phaseR, float phaseG, float phaseB, float center, float width, float length) {
        long i = Math.abs((int)System.currentTimeMillis()) / (int)length;
        double r = Math.sin(freqR * (float)i + phaseR) * (double)width + (double)center;
        double g = Math.sin(freqG * (float)i + phaseG) * (double)width + (double)center;
        double b = Math.sin(freqB * (float)i + phaseB) * (double)width + (double)center;
        return ColourHelper.RGB((float)r, (float)g, (float)b);
    }

    public static int getRainbowColour(float[] params) {
        return ColourHelper.getRainbowColour(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8]);
    }

    public static float[] getRainbowSettings(String colourCode) {
        String[] splitted = colourCode.split(";");
        float[] result = new float[]{0.3f, 0.3f, 0.3f, 0.0f, 2.0f, 4.0f, 128.0f, 127.0f, 50.0f};
        for (int i = 1; i < splitted.length; ++i) {
            try {
                result[i - 1] = Float.parseFloat(splitted[i]);
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void glColorAWT(Color color) {
        ColourHelper.glColorRGB(color.getRGB());
    }

    public static void glColorRGB(int rgb) {
        float alpha = (float)(rgb >> 24 & 0xFF) / 255.0f;
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static int RGB(float red, float green, float blue) {
        return ColourHelper.RGBA((int)red * 255, (int)green * 255, (int)blue * 255, 255);
    }

    public static int RGB(float red, float green, float blue, float alpha) {
        return ColourHelper.RGBA((int)red * 255, (int)green * 255, (int)blue * 255, (int)alpha * 255);
    }

    public static int RGB(int r, int g, int b) {
        return ColourHelper.RGBA(r, g, b, 255);
    }

    public static int RGB(String colour) {
        if (!colour.startsWith("#") || colour.length() != 7) {
            throw new IllegalArgumentException("Use #RRGGBB format");
        }
        return ColourHelper.RGB(Integer.parseInt(colour.substring(1, 3), 16), Integer.parseInt(colour.substring(3, 5), 16), Integer.parseInt(colour.substring(5, 7), 16));
    }

    public static int RGBA(int r, int g, int b, int a) {
        return a << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int tone(int colour, float scale) {
        float r = colour >> 16 & 0xFF;
        float g = colour >> 8 & 0xFF;
        float b = colour & 0xFF;
        return ColourHelper.RGB(r * scale, g * scale, b * scale);
    }
}

