/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.utils;

import com.libraries.rabbit.gui.RabbitGui;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public final class ImageCacheHelper {
    private static final File cacheFolder = new File(Minecraft.func_71410_x().field_71412_D, "/Rabbit/cache");
    private static final MessageDigest digestor;

    public static BufferedImage fetchImage(String url) throws MalformedURLException {
        return ImageCacheHelper.fetchImage(new URL(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage fetchImage(URL url) {
        BufferedImage image;
        File cachedImage;
        block12: {
            block13: {
                FileOutputStream fos;
                BufferedInputStream stream;
                block11: {
                    String externalUrl = url.toExternalForm();
                    cachedImage = ImageCacheHelper.getCachedImage(externalUrl);
                    HttpURLConnection conn = null;
                    stream = null;
                    fos = null;
                    if (cachedImage.exists()) break block13;
                    RabbitGui.logger.info("Downloading image " + cachedImage.getName());
                    try {
                        int read;
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                        conn.connect();
                        int response = conn.getResponseCode();
                        if (response < 200 || response > 207) {
                            RabbitGui.logger.warn("Received HTTP response code " + response + ". Attempting to read image anyways.");
                        }
                        stream = new BufferedInputStream(conn.getInputStream());
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buff = new byte[1024];
                        while ((read = ((InputStream)stream).read(buff)) != -1) {
                            baos.write(buff, 0, read);
                        }
                        baos.close();
                        if (!cachedImage.createNewFile()) {
                            throw new IOException("Failed to create cache image!");
                        }
                        fos = new FileOutputStream(cachedImage, false);
                        fos.write(baos.toByteArray());
                        fos.flush();
                        if (conn == null) break block11;
                        conn.disconnect();
                    }
                    catch (IOException e) {
                        RabbitGui.logger.error("Failed to fetch image from URL " + externalUrl, (Throwable)e);
                        break block12;
                    }
                    finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                        ImageCacheHelper.tryToClose(stream);
                        ImageCacheHelper.tryToClose(fos);
                    }
                }
                ImageCacheHelper.tryToClose(stream);
                ImageCacheHelper.tryToClose(fos);
                break block12;
            }
            RabbitGui.logger.info("Using cached image " + cachedImage.getName());
        }
        try {
            image = ImageIO.read(cachedImage);
        }
        catch (IOException e) {
            RabbitGui.logger.error("Failed to read image from path " + cachedImage, (Throwable)e);
            return null;
        }
        return image;
    }

    public static BufferedImage getBufferedCachedImage(String url) {
        digestor.reset();
        digestor.update(url.getBytes(Charset.forName("UTF-8")));
        String fileName = String.format("%040x", new BigInteger(1, digestor.digest()));
        try {
            return ImageIO.read(new File(cacheFolder, fileName));
        }
        catch (IOException e) {
            RabbitGui.logger.error("Failed to fetch image from URL: " + url, (Throwable)e);
            return null;
        }
    }

    public static File getCachedImage(String url) {
        digestor.reset();
        digestor.update(url.getBytes(Charset.forName("UTF-8")));
        String fileName = String.format("%040x", new BigInteger(1, digestor.digest()));
        return new File(cacheFolder, fileName);
    }

    public static BufferedImage resizeImage(BufferedImage image) {
        return ImageCacheHelper.resizeImage(image, 128, 128);
    }

    public static BufferedImage resizeImage(BufferedImage image, int width, int height) {
        BufferedImage resized = new BufferedImage(width, height, 1);
        Graphics2D graphics = resized.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(image, 0, 0, width, height, null);
        graphics.dispose();
        return resized;
    }

    public static void tryToClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                RabbitGui.logger.error("Failed to close stream " + closeable, (Throwable)e);
            }
        }
    }

    static {
        try {
            digestor = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (!cacheFolder.exists()) {
            cacheFolder.mkdirs();
        }
    }
}

