/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.utils;

import com.google.common.collect.Maps;
import com.libraries.rabbit.gui.RabbitGui;
import com.libraries.rabbit.gui.utils.ImageCacheHelper;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TextureHelper {
    private static Map<UUID, Pair<String, DynamicTexture>> dynamicImages = Maps.newHashMap();
    private static Map<UUID, Pair<Integer, Integer>> dynamicImageInfo = Maps.newHashMap();
    private static Map<UUID, ResourceLocation> staticImages = Maps.newHashMap();
    private static Map<UUID, Pair<Integer, Integer>> ImageSizes = Maps.newHashMap();
    private static ResourceLocation defaultTexture = new ResourceLocation("Minecraft", "textures/items/barrier.png");

    public static void addDynamicTexture(UUID textureId, URL textureLocation) throws IOException {
        BufferedImage bufImg = ImageCacheHelper.fetchImage(textureLocation);
        if (bufImg == null) {
            throw new IOException();
        }
        if ((bufImg = TextureHelper.trim(bufImg)).getWidth() > 128 || bufImg.getHeight() > 128) {
            bufImg = bufImg.getWidth() != bufImg.getHeight() ? TextureHelper.resize(bufImg, bufImg.getWidth(), bufImg.getHeight()) : ImageCacheHelper.resizeImage(bufImg);
        }
        dynamicImageInfo.put(textureId, (Pair<Integer, Integer>)new ImmutablePair((Object)bufImg.getWidth(), (Object)bufImg.getHeight()));
        dynamicImages.put(textureId, (Pair<String, DynamicTexture>)new ImmutablePair((Object)textureLocation.getPath(), (Object)new DynamicTexture(bufImg)));
    }

    public static void addStaticTexture(UUID textureId, ResourceLocation texture) {
        staticImages.put(textureId, texture);
    }

    public static void addTexture(UUID textureId, String textureLocation) {
        if (textureLocation != null && !textureLocation.isEmpty()) {
            try {
                TextureHelper.addDynamicTexture(textureId, new URL(textureLocation));
                RabbitGui.logger.info("Added Texture " + textureLocation + " to Dynamic Textures");
            }
            catch (MalformedURLException e) {
                try {
                    staticImages.put(textureId, new ResourceLocation(textureLocation));
                    RabbitGui.logger.info("Added Texture " + textureLocation + " to Static Textures");
                }
                catch (NullPointerException npe) {
                    RabbitGui.logger.info("Failed Adding Texture " + textureLocation + " to Textures");
                }
            }
            catch (IOException e) {
                try {
                    staticImages.put(textureId, new ResourceLocation(textureLocation));
                    RabbitGui.logger.info("Added Texture " + textureLocation + " to Static Textures");
                }
                catch (NullPointerException npe) {
                    RabbitGui.logger.info("Failed Adding Texture " + textureLocation + " to Textures");
                }
            }
        }
    }

    public static void bindTexture(UUID textureId) {
        if (dynamicImages.containsKey(textureId)) {
            GlStateManager.func_179144_i((int)((DynamicTexture)dynamicImages.get(textureId).getRight()).func_110552_b());
        } else if (staticImages.containsKey(textureId)) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(staticImages.get(textureId));
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(defaultTexture);
        }
    }

    public static DynamicTexture getDynamicTexture(UUID textureId) {
        if (TextureHelper.isTextureDynamic(textureId)) {
            return (DynamicTexture)dynamicImages.get(textureId).getRight();
        }
        return null;
    }

    public static Pair<Integer, Integer> getDynamicTextureInfo(UUID textureId) {
        return dynamicImageInfo.get(textureId);
    }

    public static String getDynamicTextureLocation(UUID textureId) {
        if (TextureHelper.isTextureDynamic(textureId)) {
            return (String)dynamicImages.get(textureId).getLeft();
        }
        return null;
    }

    public static ResourceLocation getStaticTexture(UUID textureId) {
        return staticImages.get(textureId);
    }

    public static Pair<Integer, Integer> getTextureWidthAndHeight(UUID textureId) {
        int width = 0;
        int height = 0;
        if (TextureHelper.isTextureStatic(textureId)) {
            try {
                BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(TextureHelper.getStaticTexture(textureId)).func_110527_b());
                width = image.getWidth();
                height = image.getHeight();
            }
            catch (IOException ioex) {
                throw new RuntimeException("Can't get resource", ioex);
            }
        }
        if (TextureHelper.isTextureDynamic(textureId)) {
            try {
                BufferedImage image = ImageIO.read(new URL((String)dynamicImages.get(textureId).getLeft()));
                width = image.getWidth();
                height = image.getHeight();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new ImmutablePair((Object)width, (Object)height);
    }

    private static int getTrimmedHeight(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int trimmedHeight = 0;
        block0: for (int i = 0; i < width; ++i) {
            for (int j = height - 1; j >= 0; --j) {
                if (img.getRGB(i, j) >> 24 == 0 || j <= trimmedHeight) continue;
                trimmedHeight = j;
                continue block0;
            }
        }
        return trimmedHeight;
    }

    private static int getTrimmedWidth(BufferedImage img) {
        int height = img.getHeight();
        int width = img.getWidth();
        int trimmedWidth = 0;
        block0: for (int i = 0; i < height; ++i) {
            for (int j = width - 1; j >= 0; --j) {
                if (img.getRGB(j, i) >> 24 == 0 || j <= trimmedWidth) continue;
                trimmedWidth = j;
                continue block0;
            }
        }
        return trimmedWidth;
    }

    private static int getXMostPos(BufferedImage img) {
        int width;
        int height = img.getHeight();
        int x = width = img.getWidth();
        block0: for (int i = 0; i < height; ++i) {
            for (int j = width - 1; j >= 0; --j) {
                if (img.getRGB(j, i) >> 24 == 0 || j >= x) continue;
                x = j;
                continue block0;
            }
        }
        return x;
    }

    private static int getYMostPos(BufferedImage img) {
        int height;
        int width = img.getWidth();
        int y = height = img.getHeight();
        block0: for (int i = 0; i < width; ++i) {
            for (int j = height - 1; j >= 0; --j) {
                if (img.getRGB(i, j) >> 24 == 0 || j >= y) continue;
                y = j;
                continue block0;
            }
        }
        return y;
    }

    public static boolean isTextureDynamic(UUID textureId) {
        return dynamicImages.containsKey(textureId);
    }

    public static boolean isTextureStatic(UUID textureId) {
        return staticImages.containsKey(textureId);
    }

    public static BufferedImage resize(BufferedImage img, int width, int height) {
        float scale;
        int newW = 0;
        int newH = 0;
        if (width > 128) {
            scale = 128.0f / (float)width;
            newW = (int)((float)width * scale);
            newH = (int)((float)height * scale);
        } else {
            scale = 128.0f / (float)height;
            newW = (int)((float)width * scale);
            newH = (int)((float)height * scale);
        }
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public static boolean textureExists(UUID textureId) {
        return staticImages.containsKey(textureId) || dynamicImages.containsKey(textureId);
    }

    public static BufferedImage trim(BufferedImage img) {
        int width = TextureHelper.getTrimmedWidth(img);
        int height = TextureHelper.getTrimmedHeight(img);
        int xpos = TextureHelper.getXMostPos(img);
        int ypos = TextureHelper.getYMostPos(img);
        return img.getSubimage(xpos, ypos, width - xpos, height - ypos);
    }
}

