/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.database.stats;

import com.robertx22.database.IGUID;
import com.robertx22.database.MinMax;
import com.robertx22.database.stats.IStatEffect;
import com.robertx22.database.stats.StatMod;
import com.robertx22.saveclasses.StatData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.enumclasses.Elements;
import com.robertx22.uncommon.enumclasses.StatTypes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;

public abstract class Stat
implements IGUID {
    public int MaximumPercent = 0;
    public int MinimumAmount = 0;
    public boolean hasMinimumAmount = true;
    public int StatMinimum = 0;
    public int BaseFlat = 0;
    public static String STAT_PREFIX = " * ";
    public ArrayList<IStatEffect> Effects;

    @Override
    public String GUID() {
        return this.Guid();
    }

    public abstract String unlocString();

    public String localizedString() {
        return CLOC.stat(this.unlocString().toLowerCase().replaceAll(" ", "_"));
    }

    public abstract boolean IsPercent();

    public abstract String Guid();

    public abstract boolean ScalesToLevel();

    public abstract Elements Element();

    private String printValue(StatModData data, int level) {
        float val = data.GetActualVal(level);
        DecimalFormat format = new DecimalFormat();
        if (val < 10.0f) {
            format.setMaximumFractionDigits(1);
            return format.format(val);
        }
        int intval = (int)val;
        return intval + "";
    }

    public String NameText(boolean IsSet, StatModData data) {
        StatMod mod = data.GetBaseMod();
        Stat basestat = mod.GetBaseStat();
        String str = basestat.localizedString();
        if (mod.Type().equals((Object)StatTypes.Percent) && basestat.IsPercent()) {
            str = str + " " + CLOC.word("percent");
        }
        if (IsSet) {
            return TextFormatting.RED + STAT_PREFIX + str + ": ";
        }
        return TextFormatting.RED + str + ": ";
    }

    public String NameAndValueText(StatModData data, int level, boolean IsSet) {
        float val = data.GetActualVal(level);
        String minusplus = val > 0.0f ? "+" : "";
        return this.NameText(IsSet, data) + minusplus + this.printValue(data, level);
    }

    public List<String> getTooltipList(MinMax minmax, StatModData data, int level, boolean IsNotSet) {
        ArrayList<String> list = new ArrayList<String>();
        StatMod mod = data.GetBaseMod();
        Stat basestat = mod.GetBaseStat();
        String text = this.NameAndValueText(data, level, IsNotSet);
        if (mod.Type() == StatTypes.Flat) {
            if (basestat.IsPercent()) {
                text = text + "%";
            }
        } else {
            text = mod.Type() == StatTypes.Percent ? text + "%" : text + "% " + CLOC.word("multi");
        }
        if (GuiScreen.func_146272_n() && IsNotSet) {
            StatModData min = StatModData.Load(data.GetBaseMod(), minmax.Min);
            StatModData max = StatModData.Load(data.GetBaseMod(), minmax.Max);
            text = text + TextFormatting.BLUE + " (" + min.printValue(level) + " - " + max.printValue(level) + ")";
        }
        list.add(text);
        return list;
    }

    public int CalcVal(StatData data, EntityData.UnitData Source2) {
        float finalValue = 0 + this.BaseFlat;
        finalValue += (float)this.StatMinimum;
        if (this.ScalesToLevel()) {
            finalValue *= (float)Source2.getLevel();
        }
        finalValue += data.Flat;
        finalValue *= 1.0f + data.Percent / 100.0f;
        finalValue *= 1.0f + data.Multi / 100.0f;
        if (this.hasMinimumAmount && finalValue < (float)this.MinimumAmount) {
            finalValue = this.MinimumAmount;
        }
        if (this.IsPercent() && this.MaximumPercent > 0 && finalValue > (float)this.MaximumPercent) {
            finalValue = this.MaximumPercent;
        }
        data.Value = finalValue;
        return (int)finalValue;
    }

    public boolean IsShownOnTooltip() {
        return true;
    }
}

