/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dimensions.blocks;

import com.robertx22.config.ModConfig;
import com.robertx22.dimensions.MyTeleporter;
import com.robertx22.dimensions.blocks.TileMapPortal;
import com.robertx22.saveclasses.MapWorldData;
import com.robertx22.uncommon.SLOC;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MapPortalBlock
extends BlockEndPortal {
    @GameRegistry.ObjectHolder(value="mmorpg:map_portal_block")
    public static Block BLOCK = null;

    public MapPortalBlock() {
        super(Material.field_151567_E);
        this.setRegistryName(new ResourceLocation("mmorpg", "map_portal_block"));
        this.func_149663_c("mmorpg:map_portal_block");
        this.func_149711_c(1.5f);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new MapPortalBlock());
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        try {
            TileEntity en;
            if (!world.field_72995_K && entity instanceof EntityPlayer && !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && (en = world.func_175625_s(pos)) instanceof TileMapPortal) {
                TileMapPortal portal = (TileMapPortal)en;
                portal.ontick();
                if (portal.readyToTeleport() && portal.id != entity.field_71093_bK) {
                    WorldServer worldserver = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(portal.id);
                    WorldData.IWorldData data = Load.World((ICapabilityProvider)DimensionManager.getWorld((int)portal.id));
                    if (data == null) {
                        entity.func_145747_a((ITextComponent)SLOC.chat("world_doesnt_exist"));
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    } else if (data.isSetForDelete()) {
                        entity.func_145747_a((ITextComponent)SLOC.chat("world_is_closed"));
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    } else if (data.isMapWorld()) {
                        MapWorldData worlddata = data.getWorldData();
                        if (worlddata.joinedPlayerIDs.size() < ModConfig.Server.MAX_PLAYERS_PER_MAP || worlddata.joinedPlayerIDs.contains(entity.func_110124_au().toString())) {
                            if (!worlddata.joinedPlayerIDs.contains(entity.func_110124_au().toString())) {
                                worlddata.joinedPlayerIDs.add(entity.func_110124_au().toString());
                                data.setWorldData(worlddata);
                            }
                            entity.func_145747_a(SLOC.chat("traveling_to_mapworld").func_150258_a(portal.id + ""));
                            WorldServer w = DimensionManager.getWorld((int)portal.id);
                            BlockPos pos1 = w.func_175694_M();
                            BlockPos pos2 = w.field_73011_w.getRandomizedSpawnPoint();
                            entity.changeDimension(portal.id, (ITeleporter)new MyTeleporter(world, pos2, (EntityPlayer)entity));
                        }
                        if (worlddata.joinedPlayerIDs.size() > ModConfig.Server.MAX_PLAYERS_PER_MAP) {
                            entity.func_145747_a((ITextComponent)SLOC.chat("mapworld_max_capacity"));
                        }
                    } else {
                        entity.func_145747_a((ITextComponent)SLOC.chat("not_mapworld"));
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileMapPortal();
    }
}

