/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.generation.blueprints;

import com.robertx22.config.ModConfig;
import com.robertx22.database.rarities.ItemRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.generation.RarityGen;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;

public class ItemBlueprint {
    public int MagicFind = 0;
    public int rarity;
    public boolean RandomRarity = true;
    public int level;
    public boolean LevelRange = true;
    public int LevelVariance = 3;
    public int minRarity = -1;
    public int maxRarity = 5;
    public int minLevel = 1;

    public ItemBlueprint(int level) {
        if (level > ModConfig.Server.MAXIMUM_PLAYER_LEVEL) {
            level = ModConfig.Server.MAXIMUM_PLAYER_LEVEL;
        }
        this.level = level;
    }

    public void SetSpecificRarity(int i) {
        this.rarity = i;
        this.RandomRarity = false;
    }

    public int GetRarity() {
        if (this.RandomRarity) {
            if (this.minRarity > -1 || this.maxRarity < 5) {
                ItemRarity rar = Rarities.Items.get(RarityGen.Random(0, ListUtils.CollectionToList(Rarities.Items)).Rank());
                while (rar.Rank() < this.minRarity || rar.Rank() > this.maxRarity) {
                    rar = Rarities.Items.get(RarityGen.Random(0, ListUtils.CollectionToList(Rarities.Items)).Rank());
                }
                return rar.Rank();
            }
            return RarityGen.Random(0, ListUtils.CollectionToList(Rarities.Items)).Rank();
        }
        return this.rarity;
    }

    public int GetLevel() {
        if (this.LevelRange) {
            int lvl = RandomUtils.RandomRange(this.level - this.LevelVariance, this.level + this.LevelVariance);
            if (lvl < this.minLevel) {
                lvl = this.minLevel;
            }
            if (lvl > ModConfig.Server.MAXIMUM_PLAYER_LEVEL) {
                lvl = ModConfig.Server.MAXIMUM_PLAYER_LEVEL;
            }
            return lvl;
        }
        if (this.level < this.minLevel) {
            this.level = this.minLevel;
        }
        if (this.level > ModConfig.Server.MAXIMUM_PLAYER_LEVEL) {
            this.level = ModConfig.Server.MAXIMUM_PLAYER_LEVEL;
        }
        return this.level;
    }
}

