/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.generation.blueprints;

import com.robertx22.generation.blueprints.GearBlueprint;
import com.robertx22.items.unique_items.IUnique;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import java.util.List;

public class UniqueBlueprint
extends GearBlueprint {
    private String guid = "";
    public boolean uniqueIsRandom = true;
    public int map_tier = 0;
    public int tier = -1;
    private boolean randomTier = true;

    public UniqueBlueprint(int level, int map_tier, boolean randomTier) {
        super(level);
        this.randomTier = randomTier;
        this.map_tier = map_tier;
    }

    public UniqueBlueprint(int level, String guid) {
        super(level);
        this.guid = guid;
        this.uniqueIsRandom = false;
    }

    public int GetTier() {
        if (this.tier < 0) {
            this.tier = this.randomTier ? (this.map_tier == 0 ? 0 : RandomUtils.RandomRange(0, this.map_tier)) : this.map_tier;
        }
        return this.tier;
    }

    public IUnique getUnique() {
        if (this.uniqueIsRandom) {
            this.tier = this.GetTier();
            if (!this.randomTier) {
                return (IUnique)RandomUtils.WeightedRandom(ListUtils.CollectionToList(IUnique.getAllUniquesOfTier(this.map_tier, IUnique.ITEMS.values())));
            }
            return this.randomUnique();
        }
        return (IUnique)IUnique.ITEMS.get(this.guid);
    }

    private IUnique randomUnique() {
        List<IUnique> possible = IUnique.filterUniquesByType(this.gearType, IUnique.getAllPossibleUniqueDrops(this.map_tier, IUnique.ITEMS.values()));
        IUnique unique = (IUnique)RandomUtils.WeightedRandom(ListUtils.CollectionToList(possible));
        return unique;
    }
}

