/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.items.gearitems.bases;

import com.robertx22.database.rarities.ItemRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.saveclasses.SpellItemData;
import com.robertx22.spells.bases.BaseSpell;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.datasaving.Spell;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BaseSpellItem
extends Item {
    public abstract String GUID();

    public abstract BaseSpell Spell();

    public BaseSpellItem() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setRegistryName(this.GUID().toLowerCase());
        this.func_77655_b(this.getRegistryName().toString());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        SpellItemData data = Spell.Load(stack);
        if (data != null && data.GetSpell() != null) {
            BaseSpell spell = data.GetSpell();
            ItemRarity rarity = Rarities.Items.get(data.rarity);
            tooltip.add(TextFormatting.YELLOW + CLOC.word("level") + ": " + data.level);
            tooltip.add("");
            boolean moreInfo = GuiScreen.func_146272_n();
            tooltip.add(TextFormatting.GREEN + CLOC.word("stats") + ": ");
            tooltip.add(" * " + TextFormatting.RED + data.GetManaDesc(moreInfo));
            tooltip.add(" * " + TextFormatting.RED + data.GetBaseDesc(moreInfo));
            if (spell.hasScalingValue()) {
                tooltip.add(" * " + TextFormatting.RED + data.GetScalingDesc(moreInfo));
            }
            tooltip.add("");
            tooltip.add(TextFormatting.AQUA + "Type: " + this.Spell().typeString());
            tooltip.add("");
            tooltip.add(TextFormatting.LIGHT_PURPLE + data.GetSpell().GetDescription(data));
            tooltip.add("");
            tooltip.add(rarity.Color() + CLOC.word("rarity") + ": " + rarity.locName());
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            this.Spell().cast(worldIn, playerIn, handIn, 5, null);
        } else {
            try {
                SpellItemData data = Spell.Load(playerIn.func_184586_b(handIn));
                if (data != null && this.Spell().CanCast(playerIn, data)) {
                    this.Spell().cast(worldIn, playerIn, handIn, 5, data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }
}

