/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.items.unique_items;

import baubles.api.IBauble;
import com.robertx22.database.IGUID;
import com.robertx22.database.stats.StatMod;
import com.robertx22.items.gearitems.bases.BaseArmorItem;
import com.robertx22.items.gearitems.bases.IGearItem;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.utilityclasses.ITiered;
import com.robertx22.uncommon.utilityclasses.IWeighted;
import com.robertx22.uncommon.utilityclasses.RegisterUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public interface IUnique
extends IWeighted,
ITiered,
IGUID,
IGearItem {
    public static final HashMap<String, Item> ITEMS = new HashMap();
    public static final List<IUnique> all = new ArrayList<IUnique>();

    public static List<IUnique> getAll() {
        if (all.isEmpty()) {
            for (Item item : ITEMS.values()) {
                IUnique uniq = (IUnique)item;
                all.add(uniq);
            }
        }
        return all;
    }

    @Override
    default public int Weight() {
        return UncommonWeight;
    }

    default public String locName() {
        return CLOC.uniqueName(this.GUID());
    }

    default public String locDesc() {
        return CLOC.uniqueDesc(this.GUID());
    }

    public List<StatMod> uniqueStats();

    public String slot();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS.values()) {
            item.func_77625_d(1);
            if (item instanceof IBauble) {
                item.func_77656_e(0);
            } else {
                item.func_77656_e(BaseArmorItem.MAX_GEAR_DURABILITY);
            }
            IUnique uniq = (IUnique)item;
            item.setRegistryName("uniques/" + uniq.slot().toLowerCase() + "/" + uniq.GUID());
            item.func_77655_b("mmorpg.unique." + uniq.GUID());
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        for (Item item : ITEMS.values()) {
            RegisterUtils.registerRender(item);
        }
    }

    public static List<IUnique> getAllUniquesOfTier(int tier, Collection<Item> coll) {
        ArrayList<IUnique> list = new ArrayList<IUnique>();
        for (Item item : coll) {
            IUnique baseu = (IUnique)item;
            if (tier != baseu.Tier()) continue;
            list.add((IUnique)item);
        }
        return list;
    }

    public static List<IUnique> getAllPossibleUniqueDrops(int tier, Collection<Item> coll) {
        ArrayList<IUnique> list = new ArrayList<IUnique>();
        for (Item item : coll) {
            IUnique baseu = (IUnique)item;
            if (tier < baseu.Tier()) continue;
            list.add((IUnique)item);
        }
        return list;
    }

    public static List<IUnique> filterUniquesByType(String type, List<IUnique> coll) {
        ArrayList<IUnique> list = new ArrayList<IUnique>();
        for (IUnique item : coll) {
            if (!item.slot().equals(type) && !type.equals("random") && !type.equals("")) continue;
            list.add(item);
        }
        return list;
    }
}

