/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.loot;

import com.robertx22.config.ModConfig;
import com.robertx22.database.rarities.ItemRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.ItemStack;

public class LootUtils {
    static final int LEVEL_DISTANCE_PUNISHMENT_ACTIVATION = ModConfig.Server.LEVEL_DISTANCE_PUNISHMENT_ACTIVATION;

    public static float ApplyLevelDistancePunishment(EntityData.UnitData mob, EntityData.UnitData player, float chance) {
        int difference = Math.abs(player.getLevel() - mob.getLevel());
        int maxlvl = ModConfig.Server.MAXIMUM_PLAYER_LEVEL;
        if (difference > LEVEL_DISTANCE_PUNISHMENT_ACTIVATION) {
            if (player.getLevel() == maxlvl && mob.getLevel() > maxlvl) {
                return chance;
            }
            float levelDiff = 1.0f;
            levelDiff = player.getLevel() > mob.getLevel() ? (float)mob.getLevel() / (float)player.getLevel() : (float)player.getLevel() / (float)mob.getLevel();
            if (levelDiff > 1.0f) {
                levelDiff = 1.0f;
            }
            return chance * levelDiff;
        }
        return chance;
    }

    public static ItemStack RandomDamagedGear(ItemStack stack, ItemRarity rar) {
        if (stack.func_77958_k() > 0) {
            float damage = (float)RandomUtils.RandomRange(rar.SpawnDurabilityHit().Min, rar.SpawnDurabilityHit().Max) / 100.0f;
            stack.func_77964_b((int)(damage * (float)stack.func_77958_k()));
        }
        return stack;
    }

    public static float applyLootMultipliers(float chance, EntityData.UnitData player, EntityData.UnitData mob, EntityLivingBase entity, WorldData.IWorldData world) {
        float after_mob_health;
        float first = chance;
        float after_rarity = first * Rarities.Mobs.get(mob.getRarity()).LootMultiplier();
        float after_world = after_mob_health = after_rarity * (1.0f + entity.func_110138_aP() / 20.0f);
        if (world.isMapWorld()) {
            after_world = after_mob_health * 1.0f + (float)(world.getMap().getBonusLootAmount() / 100);
        }
        if (entity instanceof EntitySlime) {
            after_world /= 15.0f;
        }
        float perkillsbonus = player.getLootBonusPerAffixKills(world.getMap());
        float after_peraffixkill = after_world * (1.0f + perkillsbonus / 100.0f);
        return after_peraffixkill;
    }

    public static int WhileRoll(float chance) {
        int amount = 0;
        while (chance > 0.0f) {
            float currentChance = chance;
            float maxChance = 75.0f;
            if (currentChance > maxChance) {
                currentChance = maxChance;
            }
            chance -= currentChance;
            if (!RandomUtils.roll(currentChance)) continue;
            ++amount;
        }
        return amount;
    }
}

