/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.loot.gens;

import com.robertx22.loot.LootUtils;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.utilityclasses.EntityTypeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public abstract class BaseLootGen {
    public int amount = 0;
    public WorldData.IWorldData world;
    public int world_tier;

    public abstract float BaseChance();

    public boolean hasLevelDistancePunishment() {
        return true;
    }

    protected abstract ItemStack generateOne();

    public List<ItemStack> generate() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.amount; ++i) {
            try {
                list.add(this.generateOne());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public BaseLootGen(float multi, WorldData.IWorldData world) {
        this.world = world;
        this.world_tier = world.getTier();
        float chance = this.BaseChance();
        this.amount = LootUtils.WhileRoll(chance *= multi);
    }

    public BaseLootGen(EntityData.UnitData mob, EntityData.UnitData player, WorldData.IWorldData world, EntityLivingBase victim) {
        this.world = world;
        this.world_tier = world.getTier();
        float chance = this.BaseChance();
        float entity_type_multi = EntityTypeUtils.getLootMulti((Entity)victim);
        chance *= entity_type_multi;
        if (this.hasLevelDistancePunishment()) {
            chance = LootUtils.ApplyLevelDistancePunishment(mob, player, chance);
        }
        chance = LootUtils.applyLootMultipliers(chance, player, mob, victim, world);
        this.amount = LootUtils.WhileRoll(chance);
    }
}

