/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.loot.gens;

import com.robertx22.config.ModConfig;
import com.robertx22.generation.GearGen;
import com.robertx22.generation.blueprints.GearBlueprint;
import com.robertx22.loot.LootUtils;
import com.robertx22.loot.gens.BaseLootGen;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Gear;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class GearLootGen
extends BaseLootGen {
    GearBlueprint gearPrint;

    public GearLootGen(EntityData.UnitData mob, EntityData.UnitData player, WorldData.IWorldData world, EntityLivingBase victim) {
        super(mob, player, world, victim);
        this.gearPrint = new GearBlueprint(mob.getLevel());
    }

    public GearLootGen(float multi, WorldData.IWorldData world, int level) {
        super(multi, world);
        this.gearPrint = new GearBlueprint(level);
    }

    @Override
    public float BaseChance() {
        return ModConfig.DropRates.GEAR_DROPRATE;
    }

    @Override
    public ItemStack generateOne() {
        ItemStack stack = GearGen.CreateStack(this.gearPrint);
        GearItemData gear = Gear.Load(stack);
        return LootUtils.RandomDamagedGear(stack, gear.GetRarity());
    }
}

