/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.network;

import com.robertx22.config.ModConfig;
import com.robertx22.mmorpg.Main;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessagePackage
implements IMessage {
    public String text;
    public String type;

    public MessagePackage() {
    }

    public MessagePackage(String name, MessageTypes type) {
        this.text = name;
        this.type = type.name();
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.text = tag.func_74779_i("text");
        this.type = tag.func_74779_i("type");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("text", this.text);
        tag.func_74778_a("type", this.type);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<MessagePackage, IMessage> {
        public IMessage onMessage(final MessagePackage message, final MessageContext ctx) {
            Runnable noteThread = new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageTypes type = MessageTypes.valueOf(message.type);
                        if ((type.equals((Object)MessageTypes.NoEnergy) || type.equals((Object)MessageTypes.NoMana)) && ModConfig.Client.SHOW_LOW_ENERGY_MANA_WARNING) {
                            EntityPlayer player = Main.proxy.getPlayerEntityFromContext(ctx);
                            player.func_184185_a(SoundEvents.field_187745_eA, 0.5f, 0.0f);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            noteThread.run();
            return null;
        }
    }

    public static enum MessageTypes {
        NoEnergy,
        NoMana;

    }
}

