/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses;

import com.robertx22.config.DimensionConfigs;
import com.robertx22.config.ModConfig;
import com.robertx22.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.database.rarities.MobRarity;
import com.robertx22.database.stat_types.offense.PhysicalDamage;
import com.robertx22.database.stat_types.resources.Energy;
import com.robertx22.database.stat_types.resources.Health;
import com.robertx22.database.stat_types.resources.Mana;
import com.robertx22.database.stats.Stat;
import com.robertx22.db_lists.Rarities;
import com.robertx22.db_lists.Stats;
import com.robertx22.mmorpg.Main;
import com.robertx22.network.EntityUnitPackage;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.StatData;
import com.robertx22.saveclasses.effects.StatusEffectData;
import com.robertx22.saveclasses.mapitem.MapAffixData;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.capability.bases.CommonStatUtils;
import com.robertx22.uncommon.capability.bases.MobStatUtils;
import com.robertx22.uncommon.capability.bases.PlayerStatUtils;
import com.robertx22.uncommon.datasaving.Gear;
import com.robertx22.uncommon.effectdatas.DamageEffect;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class Unit {
    @Store
    public HashMap<String, StatData> MyStats = null;
    @Store
    public HashMap<String, Integer> WornSets = new HashMap();
    @Store
    public HashMap<String, StatusEffectData> statusEffects = new HashMap();
    @Store
    public HashMap<String, MapAffixData> mapAffixes = new HashMap();
    @Store
    public String GUID = UUID.randomUUID().toString();

    public void InitMobStats() {
        if (this.MyStats == null) {
            this.MyStats = new HashMap();
            for (Stat stat : Stats.All.values()) {
                this.MyStats.put(stat.GUID(), new StatData(stat));
            }
        }
    }

    private float getHpAdded(EntityLivingBase entity, MobRarity rar, EntityData.UnitData data) {
        float hpadded = entity.func_110138_aP() * (float)data.getLevel();
        hpadded = entity instanceof EntityPlayer ? (hpadded *= ModConfig.Server.PLAYER_HEART_TO_HEALTH_CONVERSION) : (hpadded *= 2.0f * rar.HealthMultiplier());
        return hpadded;
    }

    public void InitPlayerStats() {
        if (this.MyStats == null) {
            this.MyStats = new HashMap();
            for (Stat stat : Stats.All.values()) {
                this.MyStats.put(stat.GUID(), new StatData(stat));
            }
        } else {
            for (Stat stat : Stats.All.values()) {
                if (this.MyStats.containsKey(stat.Guid())) continue;
                this.MyStats.put(stat.GUID(), new StatData(stat));
            }
            HashMap<String, StatData> stats = new HashMap<String, StatData>(this.MyStats);
            for (Map.Entry<String, StatData> entry : stats.entrySet()) {
                if (Stats.All.containsKey(entry.getKey())) continue;
                this.MyStats.remove(entry.getKey());
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Unit) {
            return ((Unit)obj).GUID == this.GUID;
        }
        return false;
    }

    public int hashCode() {
        return this.GUID.hashCode();
    }

    public void MobBasicAttack(EntityLivingBase source, EntityLivingBase target, EntityData.UnitData unitsource, float event_damage) {
        MobRarity rar = Rarities.Mobs.get(unitsource.getRarity());
        float mystat = unitsource.getUnit().MyStats.get((Object)PhysicalDamage.GUID).Value;
        float vanilla = event_damage * (float)unitsource.getLevel();
        float num = (mystat + vanilla) / 1.5f * rar.DamageMultiplier();
        DamageEffect dmg = new DamageEffect(source, target, (int)num);
        dmg.Activate();
    }

    public Health health() {
        return (Health)this.MyStats.get(new Health().Guid()).GetStat();
    }

    public Mana mana() {
        return (Mana)this.MyStats.get(new Mana().Guid()).GetStat();
    }

    public Energy energy() {
        return (Energy)this.MyStats.get(new Energy().Guid()).GetStat();
    }

    public StatData healthData() {
        try {
            return this.MyStats.get(new Health().Guid());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StatData manaData() {
        try {
            return this.MyStats.get(new Mana().Guid());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StatData energyData() {
        try {
            return this.MyStats.get(new Energy().Guid());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Unit Mob(EntityLivingBase entity, WorldData.IWorldData data) {
        Unit mob = new Unit();
        mob.InitMobStats();
        EntityData.UnitData endata = (EntityData.UnitData)entity.getCapability(EntityData.Data, null);
        endata.SetMobLevelAtSpawn(data, entity);
        endata.setRarity(Unit.randomRarity(entity, endata.getLevel()));
        CommonStatUtils.addMapAffixes(data, entity, mob, endata);
        MobStatUtils.AddRandomMobStatusEffects(entity, mob, Rarities.Mobs.get(endata.getRarity()));
        mob.RecalculateStats(entity, endata, endata.getLevel(), data);
        return mob;
    }

    private static int randomRarity(EntityLivingBase entity, int level) {
        double y = entity.field_70163_u;
        int minRarity = 0;
        if (entity.field_71093_bK == 0) {
            if (y < 50.0) {
                minRarity = 1;
            }
            if (y < 30.0) {
                minRarity = 2;
            }
        }
        List<MobRarity> rarities = Rarities.Mobs;
        ArrayList<MobRarity> after = new ArrayList<MobRarity>();
        DimensionConfigs config = ModConfig.Dimensions.getAll().getConfig(entity.field_71093_bK);
        for (MobRarity rar : rarities) {
            if (rar.Rank() < minRarity || rar.Rank() == 4 && config.LEVEL_FOR_MOBS_TO_BE_LEGENDARY > level || rar.Rank() == 5 && config.LEVEL_FOR_MOBS_TO_BE_MYTHICAL > level) continue;
            after.add(rar);
        }
        MobRarity finalRarity = (MobRarity)RandomUtils.WeightedRandom(ListUtils.CollectionToList(after));
        return finalRarity.Rank();
    }

    protected void ClearStats() {
        if (this.MyStats == null) {
            this.InitPlayerStats();
        }
        for (StatData stat : this.MyStats.values()) {
            stat.Clear();
        }
    }

    protected void CalcStats(EntityData.UnitData data) {
        this.MyStats.values().forEach(stat -> stat.GetStat().CalcVal((StatData)stat, data));
    }

    private DirtyCheck getDirtyCheck() {
        DirtyCheck check = new DirtyCheck();
        check.hp = (int)this.MyStats.get((Object)Health.GUID).Value;
        return check;
    }

    public void RecalculateStats(EntityLivingBase entity, EntityData.UnitData data, int level, WorldData.IWorldData world) {
        GearItemData off;
        ItemStack offhand;
        GearItemData wep;
        if (data.getUnit() == null) {
            data.setUnit(this, entity);
        }
        DirtyCheck old = this.getDirtyCheck();
        List<GearItemData> gears = PlayerStatUtils.getEquipsExcludingWeapon(entity);
        boolean gearIsValid = this.isGearCombinationValid(gears, (Entity)entity);
        ItemStack weapon = entity.func_184614_ca();
        if (weapon != null && (wep = Gear.Load(weapon)) != null && wep.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)) {
            gears.add(wep);
        }
        if ((offhand = entity.func_184592_cb()) != null && (off = Gear.Load(offhand)) != null && off.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.OffHand)) {
            gears.add(off);
        }
        Unit copy = this.Clone();
        int tier = 0;
        if (world != null) {
            tier = world.getTier();
        }
        this.ClearStats();
        MobRarity rar = Rarities.Mobs.get(data.getRarity());
        float hpadded = this.getHpAdded(entity, rar, data);
        this.MyStats.get((Object)Health.GUID).Flat += hpadded;
        if (entity instanceof EntityPlayer) {
            PlayerStatUtils.AddPlayerBaseStats(data, this);
        } else {
            MobStatUtils.AddMobcStats(data, data.getLevel());
            MobStatUtils.AddMobTierStats(this, tier);
        }
        if (gearIsValid) {
            PlayerStatUtils.CountWornSets((Entity)entity, gears, this);
            PlayerStatUtils.AddAllGearStats((Entity)entity, gears, this, level);
            PlayerStatUtils.AddAllSetStats((Entity)entity, this, level);
        }
        CommonStatUtils.AddStatusEffectStats(this, level);
        CommonStatUtils.AddMapAffixStats(this, level);
        PlayerStatUtils.CalcStatConversionsAndTransfers(copy, this);
        PlayerStatUtils.CalcTraits(data);
        this.CalcStats(data);
        DirtyCheck newcheck = this.getDirtyCheck();
        if (old.isDirty(newcheck)) {
            Main.Network.sendToAllTracking((IMessage)new EntityUnitPackage((Entity)entity, data), (Entity)entity);
        }
    }

    public boolean isGearCombinationValid(List<GearItemData> gears, Entity en) {
        int unique_items = this.countUniqueItems(gears);
        if (unique_items > ModConfig.Server.MAXIMUM_WORN_UNIQUE_ITEMS) {
            if (en instanceof EntityPlayer) {
                en.func_145747_a((ITextComponent)new TextComponentString("Gear Stats Not Added, reason: you are wearing too many unique items! Maximum Possible Unique items (excluding weapon): " + ModConfig.Server.MAXIMUM_WORN_UNIQUE_ITEMS));
            }
            return false;
        }
        int runed_items = this.countRunedItems(gears);
        if (runed_items > ModConfig.Server.MAXIMUM_WORN_RUNED_ITEMS) {
            if (en instanceof EntityPlayer) {
                en.func_145747_a((ITextComponent)new TextComponentString("Gear Stats Not Added, reason: you are wearing too many runed items! Maximum Possible Unique items (excluding weapon): " + ModConfig.Server.MAXIMUM_WORN_RUNED_ITEMS));
            }
            return false;
        }
        return true;
    }

    private int countRunedItems(List<GearItemData> gears) {
        int amount = 0;
        for (GearItemData gear : gears) {
            if (!gear.isRuned()) continue;
            ++amount;
        }
        return amount;
    }

    private int countUniqueItems(List<GearItemData> gears) {
        int amount = 0;
        for (GearItemData gear : gears) {
            if (!gear.isUnique) continue;
            ++amount;
        }
        return amount;
    }

    private Unit Clone() {
        Unit clone = new Unit();
        clone.MyStats = this.MyStats != null ? new HashMap<String, StatData>(this.MyStats) : new HashMap();
        return clone;
    }

    class DirtyCheck {
        int hp;

        DirtyCheck() {
        }

        public boolean isDirty(DirtyCheck newcheck) {
            return newcheck.hp != this.hp;
        }
    }
}

