/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses.gearitem;

import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.gearitem.StatGroupData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.uncommon.CLOC;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

@Storable
public class InfusionData
extends StatGroupData
implements ITooltipList {
    static int maxLevel = 10;
    @Store
    public int currentLevel = 1;
    public static HashMap<Integer, Float> chancePerLevel = new HashMap<Integer, Float>(){
        {
            this.put(1, Float.valueOf(100.0f));
            this.put(2, Float.valueOf(98.0f));
            this.put(3, Float.valueOf(95.0f));
            this.put(4, Float.valueOf(90.0f));
            this.put(5, Float.valueOf(80.0f));
            this.put(6, Float.valueOf(70.0f));
            this.put(7, Float.valueOf(60.0f));
            this.put(8, Float.valueOf(50.0f));
            this.put(9, Float.valueOf(25.0f));
            this.put(10, Float.valueOf(10.0f));
        }
    };

    public boolean isEmpty() {
        return this.Mods.size() == 0;
    }

    public void success() {
        this.level();
    }

    public void fail() {
        this.decrease();
    }

    public void majorFail() {
        this.decrease();
        this.decrease();
    }

    public void majorSuccess() {
        this.level();
        this.level();
    }

    public void level() {
        if (this.currentLevel < maxLevel) {
            ++this.currentLevel;
        }
    }

    public void decrease() {
        if (this.currentLevel > 0) {
            --this.currentLevel;
        }
    }

    @Override
    public List<IStatsContainer.LevelAndStats> GetAllStats(int level) {
        ArrayList<StatModData> list = new ArrayList<StatModData>(this.Mods);
        for (StatModData mod : list) {
            mod.percent += this.bonusModPercent();
        }
        return Arrays.asList(new IStatsContainer.LevelAndStats(list, level));
    }

    public int bonusModPercent() {
        return this.currentLevel * 10;
    }

    public boolean canUpgrade() {
        return this.currentLevel < maxLevel;
    }

    @Override
    public List<String> GetTooltipString(GearItemData gear) {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.isEmpty()) {
            list.add(TextFormatting.LIGHT_PURPLE + "+" + this.currentLevel + " " + CLOC.word("infusion") + ": ");
            for (IStatsContainer.LevelAndStats part : this.GetAllStats(gear.level)) {
                for (StatModData data : part.mods) {
                    list.addAll(data.GetTooltipString(gear.GetRarity().StatPercents(), part.level, true));
                }
            }
        }
        return list;
    }

    public float getChance() {
        if (chancePerLevel.containsKey(this.currentLevel)) {
            return chancePerLevel.get(this.currentLevel).floatValue();
        }
        return 1.0f;
    }
}

