/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses.gearitem;

import com.robertx22.database.MinMax;
import com.robertx22.database.rarities.RuneRarity;
import com.robertx22.database.stats.Stat;
import com.robertx22.database.stats.StatMod;
import com.robertx22.db_lists.StatMods;
import com.robertx22.generation.StatGen;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipString;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.enumclasses.StatTypes;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.text.DecimalFormat;
import java.util.List;

@Storable
public class StatModData
implements ITooltipString {
    @Store
    public StatTypes type;
    @Store
    public int percent;
    @Store
    public String baseModName;

    public static StatModData NewRandom(GearItemData gear, StatMod mod) {
        StatModData data = new StatModData();
        data.baseModName = mod.GUID();
        data.type = mod.Type();
        data.percent = StatGen.GenPercent(gear.GetRarity());
        return data;
    }

    public static StatModData NewRandom(RuneRarity rar, StatMod mod) {
        StatModData data = new StatModData();
        data.baseModName = mod.GUID();
        data.type = mod.Type();
        data.percent = StatGen.GenPercent(rar);
        return data;
    }

    public static StatModData NewStatusEffect(int percent, StatMod mod) {
        StatModData data = new StatModData();
        data.baseModName = mod.GUID();
        data.type = mod.Type();
        data.percent = percent;
        return data;
    }

    public static StatModData Load(StatMod mod, int percent) {
        StatModData data = new StatModData();
        data.baseModName = mod.GUID();
        data.type = mod.Type();
        data.percent = percent;
        return data;
    }

    public void useOnPlayer(EntityData.UnitData unit) {
        String guid = this.GetBaseMod().GetBaseStat().Guid();
        if (unit.getUnit().MyStats.containsKey(guid)) {
            unit.getUnit().MyStats.get(guid).Add(this, unit.getLevel());
        }
    }

    public StatMod GetBaseMod() {
        return StatMods.All.get(this.baseModName);
    }

    public float GetActualVal(int level) {
        StatMod mod = this.GetBaseMod();
        Stat stat = mod.GetBaseStat();
        float val = mod.GetFloatByPercent(this.percent);
        if (stat.ScalesToLevel() && mod.Type().equals((Object)StatTypes.Flat)) {
            val *= (float)level;
        }
        return val;
    }

    public String printValue(int level) {
        float val = this.GetActualVal(level);
        DecimalFormat format = new DecimalFormat();
        if (val < 10.0f) {
            format.setMaximumFractionDigits(1);
            return format.format(val);
        }
        int intval = (int)val;
        return intval + "";
    }

    @Override
    public List<String> GetTooltipString(MinMax minmax, int level, boolean IsNotSet) {
        return this.GetBaseMod().GetBaseStat().getTooltipList(minmax, this, level, IsNotSet);
    }
}

