/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses.gearitem;

import com.robertx22.database.stats.StatMod;
import com.robertx22.generation.StatGen;
import com.robertx22.items.unique_items.IUnique;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.uncommon.CLOC;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Storable
public class UniqueStatsData
implements ITooltipList,
IRerollable,
IStatsContainer {
    @Store
    public String uniqueGUID;
    @Store
    public List<Integer> percents = new ArrayList<Integer>();

    public UniqueStatsData() {
    }

    public UniqueStatsData(String GUID) {
        this.uniqueGUID = GUID;
    }

    @Override
    public void RerollFully(GearItemData gear) {
        this.RerollNumbers(gear);
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.percents.clear();
        for (int i = 0; i < 10; ++i) {
            this.percents.add(StatGen.GenPercent(gear.GetRarity()));
        }
    }

    @Override
    public List<String> GetTooltipString(GearItemData gear) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(CLOC.word("unique_stats") + ":");
        for (IStatsContainer.LevelAndStats part : this.GetAllStats(gear.level)) {
            for (StatModData data : part.mods) {
                list.addAll(data.GetTooltipString(gear.GetRarity().StatPercents(), part.level, true));
            }
        }
        return list;
    }

    public IUnique getUniqueItem() {
        return (IUnique)IUnique.ITEMS.get(this.uniqueGUID);
    }

    @Override
    public List<IStatsContainer.LevelAndStats> GetAllStats(int level) {
        IUnique unique = this.getUniqueItem();
        ArrayList<StatModData> list = new ArrayList<StatModData>();
        for (int i = 0; i < unique.uniqueStats().size(); ++i) {
            StatMod mod = unique.uniqueStats().get(i);
            list.add(StatModData.Load(mod, this.percents.get(i)));
        }
        return Arrays.asList(new IStatsContainer.LevelAndStats(list, level));
    }
}

