/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses.rune;

import com.robertx22.database.rarities.RuneRarity;
import com.robertx22.database.runewords.RuneWord;
import com.robertx22.database.stats.StatMod;
import com.robertx22.db_lists.Rarities;
import com.robertx22.db_lists.RuneWords;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.saveclasses.rune.RunesData;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Storable
public class RuneWordData
implements IStatsContainer,
ITooltipList {
    @Store
    public String name;
    @Store
    public int level;
    @Store
    public List<StatModData> Mods = new ArrayList<StatModData>();
    @Store
    public int rarity;

    @Override
    public List<IStatsContainer.LevelAndStats> GetAllStats(int level) {
        return Arrays.asList(new IStatsContainer.LevelAndStats(this.Mods, this.level));
    }

    public RuneWordData() {
    }

    public RuneWordData(RunesData data, RuneWord word) {
        this.level = data.getAverageLevel();
        int percent = data.getAveragePercents();
        this.name = word.GUID();
        this.rarity = data.getAverageRarity();
        this.Mods.clear();
        for (StatMod mod : word.mods()) {
            this.Mods.add(StatModData.Load(mod, percent));
        }
    }

    public RuneWord getRuneWord() {
        return RuneWords.All.get(this.name);
    }

    public RuneRarity getRarity() {
        return Rarities.Runes.get(this.rarity);
    }

    @Override
    public List<String> GetTooltipString(GearItemData gear) {
        ArrayList<String> list = new ArrayList<String>();
        RuneRarity rar = this.getRarity();
        RuneWord word = this.getRuneWord();
        list.add(rar.Color() + "Rune Word: " + word.locName().toUpperCase());
        for (StatModData mod : this.Mods) {
            list.addAll(mod.GetTooltipString(rar.StatPercents(), this.level, true));
        }
        return list;
    }
}

