/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses.rune;

import com.robertx22.database.runewords.RuneWord;
import com.robertx22.db_lists.RuneWords;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.saveclasses.rune.InsertedRuneData;
import com.robertx22.saveclasses.rune.RuneItemData;
import com.robertx22.saveclasses.rune.RuneWordData;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Storable
public class RunesData
implements ITooltipList,
IStatsContainer {
    @Store
    public int level = 1;
    @Store
    public List<InsertedRuneData> runes = new ArrayList<InsertedRuneData>();
    @Store
    public List<RuneWordData> runewords = new ArrayList<RuneWordData>();
    @Store
    public int capacity = 1;

    @Override
    public List<IStatsContainer.LevelAndStats> GetAllStats(int level) {
        ArrayList<IStatsContainer.LevelAndStats> list = new ArrayList<IStatsContainer.LevelAndStats>();
        for (InsertedRuneData rune : this.runes) {
            list.addAll(rune.GetAllStats(level));
        }
        for (RuneWordData word : this.runewords) {
            list.addAll(word.GetAllStats(level));
        }
        return list;
    }

    public String getRemainingRuneWordCombo() {
        String text = "";
        for (InsertedRuneData item : this.runes) {
            if (item.usedForRuneWord.length() != 0) continue;
            text = text + item.rune.toUpperCase();
        }
        return text;
    }

    public void insert(RuneItemData rune, GearItemData gear) {
        this.runes.add(new InsertedRuneData(rune.level, rune.name, Arrays.asList(rune.getModFor(gear)), rune.rarity));
    }

    public boolean canAwakenRuneWord(RuneWord word) {
        String text = "";
        block0: for (int i = 0; i < word.size(); ++i) {
            for (InsertedRuneData inserted : this.runes) {
                if (inserted.usedForRuneWord.length() != 0 || !inserted.rune.equals(word.runes().get(i).name())) continue;
                text = text + word.runes().get(i).name();
                continue block0;
            }
        }
        return text.toUpperCase().equals(word.getRuneWordCombo().toUpperCase());
    }

    public boolean AwakenRuneWord(String word) {
        RuneWord runeword = RuneWords.All.get(word);
        if (runeword != null) {
            this.runewords.add(new RuneWordData(this, runeword));
            block0: for (int i = 0; i < runeword.size(); ++i) {
                for (InsertedRuneData inserted : this.runes) {
                    if (inserted.usedForRuneWord.length() != 0 || !inserted.rune.equals(runeword.runes().get(i).name())) continue;
                    inserted.usedForRuneWord = runeword.GUID();
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    public int getAveragePercents() {
        int per = 0;
        for (InsertedRuneData rune : this.runes) {
            per += rune.getAveragePercents();
        }
        return per /= this.runes.size();
    }

    public int getAverageLevel() {
        int per = 0;
        for (InsertedRuneData rune : this.runes) {
            per += rune.level;
        }
        return per /= this.runes.size();
    }

    public int getAverageRarity() {
        int per = 0;
        for (InsertedRuneData rune : this.runes) {
            per += rune.rarity;
        }
        return per /= this.runes.size();
    }

    public boolean canFit(GearItemData gear, RuneItemData rune) {
        return this.runes.size() < this.capacity && gear.level >= rune.level && !this.alreadyContains(rune);
    }

    public boolean alreadyContains(RuneItemData rune) {
        for (InsertedRuneData r : this.runes) {
            if (!r.rune.equals(rune.name)) continue;
            return true;
        }
        return false;
    }

    public void clearRunes() {
        this.runes.clear();
    }

    @Override
    public List<String> GetTooltipString(GearItemData gear) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        String txt = "Runes: ";
        list.add(txt);
        for (InsertedRuneData rune : this.runes) {
            list.addAll(rune.GetTooltipString(gear));
        }
        int empty = this.capacity - this.runes.size();
        for (int i = 0; i < empty; ++i) {
            list.add("Rune: [ Empty ]");
        }
        list.add("");
        if (this.runewords != null && this.runewords.size() > 0) {
            for (RuneWordData word : this.runewords) {
                list.addAll(word.GetTooltipString(gear));
            }
        }
        return list;
    }
}

