/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.aoe_bomb_proj.bases;

import com.robertx22.ColoredRedstone;
import com.robertx22.spells.bases.projectile.EntityElementalBolt;
import com.robertx22.spells.bases.projectile.Targeting;
import com.robertx22.spells.potion_effects.all.EnergyRegenPotion;
import com.robertx22.spells.potion_effects.all.ManaRegenPotion;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.effectdatas.interfaces.IBuffableSpell;
import com.robertx22.uncommon.utilityclasses.SoundUtils;
import com.robertx22.uncommon.utilityclasses.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class EntityBombProjectile
extends EntityElementalBolt {
    @Override
    public double radius() {
        return 2.5;
    }

    public EntityBombProjectile(World worldIn) {
        super(worldIn);
        this.setDeathTime(60);
        this.setAirProcTime(40);
        this.setDoExpireProc(true);
        this.func_189654_d(true);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    protected boolean onExpireProc(EntityLivingBase caster) {
        return this.doEffect(caster);
    }

    public boolean doEffect(EntityLivingBase caster) {
        if (this.field_70170_p.field_72995_K) {
            SoundUtils.playSound(this, SoundEvents.field_187539_bB, 0.6f, 0.6f);
        } else {
            ColoredRedstone.SpawnAoeRedstone(this.element(), this, this.radius(), 300);
        }
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 1.0, 1.0, new int[]{0});
        boolean hit = false;
        if (!this.field_70170_p.field_72995_K && caster != null && this.effect != null) {
            List<EntityLivingBase> list = WizardryUtilities.getEntitiesWithinRadius(this.radius(), this, EntityLivingBase.class);
            for (int i = 0; i < list.size(); ++i) {
                EntityLivingBase entity1 = list.get(i);
                if (!entity1.hasCapability(EntityData.Data, null)) continue;
                this.effect.Activate(this.data, entity1);
                this.checkOnKill(entity1);
                hit = true;
            }
            return hit;
        }
        return false;
    }

    public void checkOnKill(EntityLivingBase entity) {
        if (!entity.func_70089_S() && this.getThrower() != null) {
            if (this.getBuff().equals((Object)IBuffableSpell.SpellBuffType.Energy_Regen)) {
                this.getThrower().func_70690_d(new PotionEffect((Potion)EnergyRegenPotion.INSTANCE, 400, 2));
            } else if (this.getBuff().equals((Object)IBuffableSpell.SpellBuffType.Mana_Regen)) {
                this.getThrower().func_70690_d(new PotionEffect((Potion)ManaRegenPotion.INSTANCE, 400, 2));
            }
        }
    }

    @Override
    protected Targeting.TargetType getTargetType() {
        return Targeting.TargetType.ENEMY;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        switch (result.field_72313_a) {
            case BLOCK: {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                break;
            }
            case ENTITY: {
                break;
            }
        }
    }
}

