/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.bases;

import com.robertx22.mmorpg.Main;
import com.robertx22.network.MessagePackage;
import com.robertx22.saveclasses.SpellItemData;
import com.robertx22.spells.bases.EffectCalculation;
import com.robertx22.uncommon.SLOC;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.enumclasses.Elements;
import com.robertx22.uncommon.utilityclasses.IWeighted;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class BaseSpell
implements IWeighted {
    public int DamageVariance = 50;
    public boolean ScalesWithLevel = true;

    public String typeString() {
        return this.Type().toString().replaceAll("_", " ");
    }

    public boolean hasScalingValue() {
        return true;
    }

    public boolean baseValueScalesWithLevel() {
        return true;
    }

    public abstract SpellType Type();

    public abstract String GUID();

    public abstract int ManaCost();

    public abstract int BaseValue();

    public abstract EffectCalculation ScalingValue();

    public abstract Elements Element();

    public abstract Item SpellItem();

    public abstract String GetDescription(SpellItemData var1);

    @Override
    public int Weight() {
        return 1000;
    }

    public abstract boolean cast(World var1, EntityPlayer var2, EnumHand var3, int var4, SpellItemData var5);

    public boolean CanCast(EntityPlayer caster, SpellItemData data) {
        EntityData.UnitData unit;
        if (!caster.field_70170_p.field_72995_K && (unit = Load.Unit((ICapabilityProvider)caster)) != null) {
            if (data.level > unit.getLevel()) {
                caster.func_145747_a((ITextComponent)SLOC.chat("too_low_level"));
                return false;
            }
            if (unit.hasEnoughMana(data.GetManaCost())) {
                unit.consumeMana(data.GetManaCost());
                return true;
            }
            if (caster instanceof EntityPlayerMP) {
                Main.Network.sendTo((IMessage)new MessagePackage("not_enough_mana", MessagePackage.MessageTypes.NoMana), (EntityPlayerMP)caster);
            }
        }
        return false;
    }

    public static enum SpellType {
        Single_Target_Projectile,
        Aoe_Projectile,
        Self_Heal,
        Aoe_Bomb_Projectile,
        Restore_Energy,
        Aoe_Damage_Nova;

    }
}

