/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.nova;

import com.robertx22.ColoredRedstone;
import com.robertx22.saveclasses.SpellItemData;
import com.robertx22.spells.bases.BaseSpell;
import com.robertx22.spells.bases.DamageData;
import com.robertx22.spells.bases.SpellEffectDamage;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.utilityclasses.SoundUtils;
import com.robertx22.uncommon.utilityclasses.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public abstract class BaseNovaSpell
extends BaseSpell {
    public float scaling = 0.3f;
    public double radius = 4.0;

    @Override
    public BaseSpell.SpellType Type() {
        return BaseSpell.SpellType.Aoe_Damage_Nova;
    }

    @Override
    public int ManaCost() {
        return 15;
    }

    @Override
    public int BaseValue() {
        return 5;
    }

    @Override
    public String GetDescription(SpellItemData data) {
        return CLOC.tooltip("aoe_spell_nova");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellItemData data) {
        if (!world.field_72995_K) {
            ColoredRedstone.SpawnNovaRedstone(this.Element(), (Entity)caster, this.radius, 200);
            List<EntityLivingBase> list = WizardryUtilities.getEntitiesWithinRadius(this.radius, (Entity)caster, EntityLivingBase.class);
            for (int i = 0; i < list.size(); ++i) {
                EntityLivingBase entity1 = list.get(i);
                if (!entity1.hasCapability(EntityData.Data, null) || entity1 == caster) continue;
                entity1.func_184185_a(SoundEvents.field_187903_gc, 0.7f, 0.0f);
                SpellEffectDamage effect = new SpellEffectDamage(this.Element());
                effect.Activate(new DamageData((EntityLivingBase)caster, data), entity1);
            }
        }
        SoundUtils.playSoundAtPlayer(caster, SoundEvents.field_191244_bn, 1.0f, 1.0f);
        caster.func_184609_a(hand);
        return true;
    }
}

