/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.potion_effects;

import com.robertx22.spells.potion_effects.SpellCast;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SpellPotionBase
extends Potion {
    public void register(String name) {
        this.func_76390_b(name);
    }

    public SpellPotionBase finish() {
        this.setRegistryName(this.func_76393_a());
        return this;
    }

    public abstract void performEffectEverySetTime(EntityLivingBase var1, int var2);

    public abstract int performEachXTicks();

    public List<EntityLivingBase> getEntitiesAround(Entity en, float radius) {
        return en.field_70170_p.func_72872_a(EntityLivingBase.class, en.func_174813_aQ().func_186662_g((double)radius));
    }

    public void func_76394_a(EntityLivingBase en, int amplifier) {
        if (en.field_70173_aa % this.performEachXTicks() == 0) {
            this.performEffectEverySetTime(en, amplifier);
        }
    }

    protected SpellPotionBase(boolean isBadEffectIn, int liquidColorIn) {
        super(isBadEffectIn, liquidColorIn);
        if (!isBadEffectIn) {
            this.func_188413_j();
        }
    }

    public boolean canSelfCast() {
        return false;
    }

    protected boolean isServerSideOnly() {
        return true;
    }

    public boolean func_76397_a(int duration, int amplitude) {
        return duration >= 1;
    }

    public boolean func_76403_b() {
        return true;
    }

    public void func_180793_a(Entity applier, Entity caster, @Nonnull EntityLivingBase target, int amplifier, double health) {
        if (target.field_70170_p.field_72995_K && this.isServerSideOnly()) {
            return;
        }
        SpellCast cast = new SpellCast(this, (Entity)target);
        this.doEffect(applier, caster, target, amplifier, cast);
    }

    public void func_111185_a(EntityLivingBase target, @Nonnull AbstractAttributeMap attributes, int amplifier) {
        SpellCast cast;
        if (!(target.field_70170_p.field_72995_K && this.isServerSideOnly() || (cast = new SpellCast(this, (Entity)target)) == null)) {
            this.onPotionAdd(cast, target, attributes, amplifier);
        }
        super.func_111185_a(target, attributes, amplifier);
    }

    public void func_111187_a(EntityLivingBase target, @Nonnull AbstractAttributeMap attributes, int amplifier) {
        SpellCast cast;
        if (!(target.field_70170_p.field_72995_K && this.isServerSideOnly() || (cast = new SpellCast(this, (Entity)target)) == null)) {
            this.onPotionRemove(cast, target, attributes, amplifier);
        }
        super.func_111187_a(target, attributes, amplifier);
    }

    public void onPotionAdd(SpellCast cast, EntityLivingBase target, AbstractAttributeMap attributes, int amplifier) {
    }

    public void onPotionRemove(SpellCast cast, EntityLivingBase target, AbstractAttributeMap attributes, int amplifier) {
    }

    public abstract void doEffect(Entity var1, Entity var2, EntityLivingBase var3, int var4, SpellCast var5);

    protected boolean shouldShowParticles() {
        return true;
    }

    protected boolean isAmbient() {
        return false;
    }

    public PotionEffect toPotionEffect(int amplifier) {
        return this.toPotionEffect(1, amplifier);
    }

    public PotionEffect toPotionEffect(int duration, int amplifier) {
        return new PotionEffect((Potion)this, duration, amplifier, this.isAmbient(), this.shouldShowParticles());
    }

    public SpellCast newSpellCast(Entity caster) {
        return new SpellCast(this, caster);
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == ((Object)((Object)this)).getClass();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.func_76401_j();
        hash = 31 * hash + (this.func_76398_f() ? 1 : 0);
        return hash;
    }

    public ResourceLocation getIconTexture() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        if (mc.field_71462_r != null && this.getIconTexture() != null) {
            mc.func_110434_K().func_110577_a(this.getIconTexture());
            Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        if (this.getIconTexture() != null) {
            mc.func_110434_K().func_110577_a(this.getIconTexture());
            Gui.func_146110_a((int)(x + 4), (int)(y + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
    }
}

