/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.potion_effects.all;

import com.robertx22.spells.potion_effects.SpellCast;
import com.robertx22.spells.potion_effects.SpellPotionBase;
import com.robertx22.spells.self.SpellInstantHeal;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.datasaving.Load;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class HealthRegenPotion
extends SpellPotionBase {
    public static final HealthRegenPotion INSTANCE = new HealthRegenPotion();

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE.finish());
    }

    public static SpellCast Create(Entity source) {
        return INSTANCE.newSpellCast(source);
    }

    private HealthRegenPotion() {
        super(false, 4393423);
        this.func_76390_b("mmorpg.effect.self_regen");
    }

    @Override
    public ResourceLocation getIconTexture() {
        return new ResourceLocation("mmorpg", "textures/status_effects/regen.png");
    }

    private static void apply(EntityLivingBase entity) {
    }

    @Override
    public boolean canSelfCast() {
        return true;
    }

    @Override
    public void doEffect(Entity applier, Entity caster, EntityLivingBase target, int amplifier, SpellCast cast) {
        HealthRegenPotion.apply(target);
    }

    @Override
    public void performEffectEverySetTime(EntityLivingBase entity, int amplifier) {
        try {
            if (entity.field_70170_p.field_72995_K) {
                SpellInstantHeal.spawnHealParticles(entity, 3);
            } else {
                EntityData.UnitData data = Load.Unit((ICapabilityProvider)entity);
                data.heal(entity, amplifier);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int performEachXTicks() {
        return 40;
    }
}

