/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.self;

import com.robertx22.database.stat_types.resources.Health;
import com.robertx22.items.spells.self.ItemInstantHeal;
import com.robertx22.saveclasses.SpellItemData;
import com.robertx22.spells.bases.BaseSpell;
import com.robertx22.spells.bases.EffectCalculation;
import com.robertx22.spells.bases.SpellBuffCheck;
import com.robertx22.spells.self.BaseSpellHeal;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.effectdatas.SpellBuffEffect;
import com.robertx22.uncommon.utilityclasses.SoundUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SpellInstantHeal
extends BaseSpellHeal {
    @Override
    public BaseSpell.SpellType Type() {
        return BaseSpell.SpellType.Self_Heal;
    }

    @Override
    public String GUID() {
        return "instant_heal";
    }

    @Override
    public int ManaCost() {
        return 30;
    }

    @Override
    public int BaseValue() {
        return 6;
    }

    @Override
    public EffectCalculation ScalingValue() {
        return new EffectCalculation(Health.GUID, 0.25f);
    }

    @Override
    public Item SpellItem() {
        return ItemInstantHeal.ITEM;
    }

    @Override
    public String GetDescription(SpellItemData data) {
        return CLOC.tooltip("spell_instant_heal");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellItemData data) {
        try {
            if (!world.field_72995_K) {
                EntityData.UnitData unit = Load.Unit((ICapabilityProvider)caster);
                unit.heal((EntityLivingBase)caster, data.GetDamage(unit.getUnit()));
                SoundUtils.playSoundAtPlayer(caster, SoundEvents.field_187664_bz, 1.0f, 1.0f);
                SpellBuffCheck check = new SpellBuffCheck(this.Type());
                SpellBuffEffect spelleffect = new SpellBuffEffect((EntityLivingBase)caster, check);
                spelleffect.Activate();
                this.checkSpellBuffs(caster, check);
            } else {
                SpellInstantHeal.spawnHealParticles((EntityLivingBase)caster, 10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

