/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.gui.map_stats;

import com.libraries.rabbit.gui.component.list.ScrollableDisplayList;
import com.libraries.rabbit.gui.component.list.entries.ListEntry;
import com.libraries.rabbit.gui.component.list.entries.StringEntry;
import com.libraries.rabbit.gui.show.Show;
import com.robertx22.items.misc.ItemMap;
import com.robertx22.saveclasses.MapItemData;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MapStatsGui
extends Show {
    MapItemData map;
    Minecraft mc;
    WorldData.IWorldData world;
    ScrollableDisplayList scroll = null;
    boolean setup = false;

    @Override
    public void setup() {
        WorldData.IWorldData data;
        super.setup();
        this.mc = Minecraft.func_71410_x();
        if (this.mc != null && this.mc.field_71439_g != null && (data = Load.World((ICapabilityProvider)this.mc.field_71439_g.field_70170_p)) != null) {
            this.map = data.getMap();
            this.world = data;
        }
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        this.scroll = this.displayStats();
        if (this.scroll != null && !this.setup) {
            this.scroll.setup();
            this.setup = true;
            this.scroll.setVisibleBackground(true);
            this.registerComponent(this.scroll);
        }
    }

    private ScrollableDisplayList displayStats() {
        if (this.map != null && this.mc.field_71462_r != null && this.world != null) {
            ArrayList<ListEntry> list = new ArrayList<ListEntry>();
            if (this.world.isMapWorld()) {
                for (String str : ItemMap.showTooltip(this.map, new ArrayList<String>())) {
                    this.StringToListEntry(str, list);
                }
            } else {
                this.StringToListEntry(CLOC.word("not_mapworld"), list);
            }
            int width = this.width / 2;
            int height = this.height - this.height / 5;
            ScrollableDisplayList scroll = new ScrollableDisplayList(this.width / 4, this.height / 10, width, height, 15, list);
            return scroll;
        }
        return null;
    }

    private void StringToListEntry(String str, List<ListEntry> list) {
        if (str != null) {
            StringEntry entry = new StringEntry(str);
            list.add(entry);
        }
    }
}

