/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.oregen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGen
implements IWorldGenerator {
    WorldGenerator oreGen;
    int minHeight;
    int maxHeight;
    int spawnChance;
    int dimension;

    public OreGen(Block blockToGen, int blockCount, int minHeight, int maxHeight, int spawnChance) {
        this(blockToGen, blockCount, minHeight, maxHeight, spawnChance, 0, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    public OreGen(Block blockToGen, int blockCount, int minHeight, int maxHeight, int spawnChance, int dimension) {
        this(blockToGen, blockCount, minHeight, maxHeight, spawnChance, dimension, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    public OreGen(Block blockToGen, int blockAmount, int minHeight, int maxHeight, int spawnChance, int dimension, Predicate<IBlockState> blockToReplace) {
        this.oreGen = new WorldGenMinable(blockToGen.func_176223_P(), blockAmount, blockToReplace);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.spawnChance = spawnChance;
        this.dimension = dimension;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == this.dimension) {
            this.runGenerator(this.oreGen, world, random, chunkX, chunkZ, this.spawnChance, this.minHeight, this.maxHeight);
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightdiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightdiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

