/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.utilityclasses;

import com.robertx22.db_lists.Spells;
import com.robertx22.uncommon.utilityclasses.IWeighted;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class RandomUtils {
    private static Random ran = new Random();

    public static int RandomRange(int min, int max) {
        int result = ran.nextInt(max - min);
        return result + min;
    }

    public static boolean roll(int chance) {
        Random ran = new Random();
        double ranNum = ran.nextDouble() * 100.0;
        return (double)chance > ranNum;
    }

    public static boolean roll(float chance) {
        Random ran = new Random();
        double ranNum = ran.nextDouble() * 100.0;
        return (double)chance > ranNum;
    }

    public static IWeighted WeightedRandom(List<IWeighted> lootTable) {
        double value = (double)RandomUtils.Total(lootTable) * Math.random();
        double weight = 0.0;
        for (IWeighted item : lootTable) {
            if (!(value < (weight += (double)item.Weight()))) continue;
            return item;
        }
        return null;
    }

    private static int Total(List<IWeighted> list) {
        int total = 0;
        for (IWeighted w : list) {
            total += w.Weight();
        }
        return total;
    }

    public static IWeighted WeightedRandom(Collection<IWeighted> lootTable) {
        List<IWeighted> slots = ListUtils.CollectionToList(Spells.All.values());
        return RandomUtils.WeightedRandom(slots);
    }
}

