/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.neat_mob_overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.robertx22.mine_and_slash.a_libraries.neat_mob_overlay.NeatConfig;
import com.robertx22.mine_and_slash.config.ClientContainer;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.effects.StatusEffectData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LookUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.awt.Color;
import java.util.List;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HealthBarRenderer {
    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            if (!((Boolean)ClientContainer.INSTANCE.neatConfig.renderInF1.get()).booleanValue() && !Minecraft.func_71382_s() || !NeatConfig.draw) {
                return;
            }
            Entity cameraEntity = mc.func_175606_aa();
            Frustum frustum = new Frustum();
            BlockPos renderingVector = cameraEntity.func_180425_c();
            float partialTicks = event.getPartialTicks();
            double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)partialTicks;
            double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)partialTicks;
            double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)partialTicks;
            frustum.func_78547_a(viewX, viewY, viewZ);
            if (((Boolean)ClientContainer.INSTANCE.neatConfig.showOnlyFocused.get()).booleanValue()) {
                Entity focused = LookUtils.getEntityLookedAt((Entity)mc.field_71439_g);
                if (focused != null && focused instanceof LivingEntity && focused.func_70089_S()) {
                    HealthBarRenderer.renderHealthBar((LivingEntity)focused, partialTicks, cameraEntity);
                }
            } else {
                ClientWorld client = mc.field_71441_e;
                Int2ObjectMap entitiesById = (Int2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(ClientWorld.class, (Object)client, (String)"entitiesById");
                for (Entity entity : entitiesById.values()) {
                    if (entity == null || !(entity instanceof LivingEntity) || entity == mc.field_71439_g || !entity.func_145770_h((double)renderingVector.func_177958_n(), (double)renderingVector.func_177956_o(), (double)renderingVector.func_177952_p()) || !entity.field_70158_ak && !frustum.func_78546_a(entity.func_174813_aQ()) || !entity.func_70089_S() || !entity.func_184182_bu().isEmpty()) continue;
                    HealthBarRenderer.renderHealthBar((LivingEntity)entity, partialTicks, cameraEntity);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void renderHealthBar(LivingEntity passedEntity, float partialTicks, Entity viewPoint) {
        Stack<LivingEntity> ridingStack = new Stack<LivingEntity>();
        LivingEntity entity = passedEntity;
        ridingStack.push(entity);
        EntityCap.UnitData data = Load.Unit((ICapabilityProvider)entity);
        if (data == null) {
            return;
        }
        Unit unit = data.getUnit();
        if (unit == null) {
            return;
        }
        while (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof LivingEntity) {
            entity = (LivingEntity)entity.func_184187_bx();
            ridingStack.push(entity);
        }
        Minecraft mc = Minecraft.func_71410_x();
        float pastTranslate = 0.0f;
        while (!ridingStack.isEmpty()) {
            String namestring;
            float namel;
            boolean useHue;
            float distance;
            entity = (LivingEntity)ridingStack.pop();
            boolean boss = !entity.func_184222_aU();
            String entityID = entity.func_70022_Q();
            if (((List)ClientContainer.INSTANCE.neatConfig.blacklist.get()).contains(entityID) || (distance = passedEntity.func_70032_d(viewPoint)) > (float)((Integer)ClientContainer.INSTANCE.neatConfig.maxDistance.get()).intValue() || !passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || !((Boolean)ClientContainer.INSTANCE.neatConfig.showOnBosses.get()).booleanValue() && !boss || !((Boolean)ClientContainer.INSTANCE.neatConfig.showOnPlayers.get()).booleanValue() && entity instanceof PlayerEntity) continue;
            double x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
            double y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
            double z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
            float scale = 0.026666673f;
            float maxHealth = unit.healthData().Value;
            float health = unit.health().CurrentValue(entity, unit);
            if (maxHealth <= 0.0f) continue;
            float percent = (int)(health / maxHealth * 100.0f);
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)((float)(x - renderManager.field_78725_b)), (float)((float)(y - renderManager.field_78726_c + (double)passedEntity.func_213302_cg() + (Double)ClientContainer.INSTANCE.neatConfig.heightAbove.get())), (float)((float)(z - renderManager.field_78723_d)));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)(-scale), (float)(-scale), (float)scale);
            boolean lighting = GL11.glGetBoolean((int)2896);
            GlStateManager.disableLighting();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableDepthTest();
            GlStateManager.disableTexture();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            float padding = ((Integer)ClientContainer.INSTANCE.neatConfig.backgroundPadding.get()).intValue();
            int bgHeight = (Integer)ClientContainer.INSTANCE.neatConfig.backgroundHeight.get();
            int barHeight = (Integer)ClientContainer.INSTANCE.neatConfig.barHeight.get();
            float size = boss ? (float)((Integer)ClientContainer.INSTANCE.neatConfig.plateSizeBoss.get()).intValue() : (float)((Integer)ClientContainer.INSTANCE.neatConfig.plateSize.get()).intValue();
            int r = 0;
            int g = 255;
            int b = 0;
            boolean bl = useHue = (Boolean)ClientContainer.INSTANCE.neatConfig.colorByType.get() == false;
            if (useHue) {
                float hue = Math.max(0.0f, health / maxHealth / 3.0f - 0.07f);
                Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
                r = color.getRed();
                g = color.getGreen();
                b = color.getBlue();
            }
            GlStateManager.translatef((float)0.0f, (float)pastTranslate, (float)0.0f);
            float s = 0.5f;
            ITextComponent name = data.getName(entity);
            if (Screen.hasShiftDown()) {
                name.func_150257_a((ITextComponent)new StringTextComponent(" {" + data.getType().name() + "} "));
            }
            if ((namel = (float)mc.field_71466_p.func_78256_a(namestring = name.func_150254_d()) * s) + 20.0f > size * 2.0f) {
                size = namel / 2.0f + 10.0f;
            }
            float healthSize = size * (health / maxHealth);
            if (((Boolean)ClientContainer.INSTANCE.neatConfig.drawBackground.get()).booleanValue()) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)(-size - padding), (double)(-bgHeight), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                buffer.func_181662_b((double)(-size - padding), (double)((float)barHeight + padding), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                buffer.func_181662_b((double)(size + padding), (double)((float)barHeight + padding), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                buffer.func_181662_b((double)(size + padding), (double)(-bgHeight), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                tessellator.func_78381_a();
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b((double)(-size), 0.0, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
            buffer.func_181662_b((double)(-size), (double)barHeight, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
            buffer.func_181662_b((double)size, (double)barHeight, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
            buffer.func_181662_b((double)size, 0.0, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b((double)(-size), 0.0, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
            buffer.func_181662_b((double)(-size), (double)barHeight, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
            buffer.func_181662_b((double)(healthSize * 2.0f - size), (double)barHeight, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
            buffer.func_181662_b((double)(healthSize * 2.0f - size), 0.0, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)(-size), (float)-4.5f, (float)0.0f);
            GlStateManager.scalef((float)s, (float)s, (float)s);
            mc.field_71466_p.func_211126_b(namestring, 0.0f, 0.0f, 0xFFFFFF);
            GlStateManager.pushMatrix();
            float s1 = 0.75f;
            GlStateManager.scalef((float)s1, (float)s1, (float)s1);
            int h = (Integer)ClientContainer.INSTANCE.neatConfig.hpTextHeight.get();
            String maxHpStr = TextFormatting.BOLD + NumberUtils.formatNumber((int)maxHealth);
            String hpStr = NumberUtils.formatNumber((int)health);
            String percStr = (int)percent + "%";
            if (maxHpStr.endsWith(".0")) {
                maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 2);
            }
            if (hpStr.endsWith(".0")) {
                hpStr = hpStr.substring(0, hpStr.length() - 2);
            }
            if (((Boolean)ClientContainer.INSTANCE.neatConfig.showCurrentHP.get()).booleanValue()) {
                mc.field_71466_p.func_211126_b(hpStr, 2.0f, (float)h, 0xFFFFFF);
            }
            if (((Boolean)ClientContainer.INSTANCE.neatConfig.showMaxHP.get()).booleanValue()) {
                mc.field_71466_p.func_211126_b(maxHpStr, (float)((int)(size / (s * s1) * 2.0f) - 2 - mc.field_71466_p.func_78256_a(maxHpStr)), (float)h, 0xFFFFFF);
            }
            if (((Boolean)ClientContainer.INSTANCE.neatConfig.showPercentage.get()).booleanValue()) {
                mc.field_71466_p.func_211126_b(percStr, (float)((int)(size / (s * s1)) - mc.field_71466_p.func_78256_a(percStr) / 2), (float)h, -1);
            }
            if (((Boolean)ClientContainer.INSTANCE.neatConfig.enableDebugInfo.get()).booleanValue() && mc.field_71474_y.field_74330_P) {
                mc.field_71466_p.func_211126_b("GEAR_FACTORY_ID: \"" + entityID + "\"", 0.0f, (float)(h + 16), -1);
            }
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            s1 = 0.5f;
            GlStateManager.scalef((float)s1, (float)s1, (float)s1);
            GlStateManager.translatef((float)(size / (s * s1) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
            mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            int off = 0;
            for (StatusEffectData statusdata : unit.statusEffects.values()) {
                HealthBarRenderer.renderIcon(off, 0, new ItemStack((IItemProvider)statusdata.GetEffect().ItemModel()), 16, 16);
                off -= 16;
            }
            if (!data.shouldDropLoot()) {
                HealthBarRenderer.renderIcon(off, 0, new ItemStack((IItemProvider)Items.field_221803_eL), 16, 16);
                off -= 16;
            }
            GlStateManager.popMatrix();
            GlStateManager.disableBlend();
            GlStateManager.enableDepthTest();
            GlStateManager.depthMask((boolean)true);
            if (lighting) {
                GlStateManager.enableLighting();
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
            pastTranslate -= (float)(bgHeight + barHeight) + padding;
        }
    }

    public static void renderIcon(int vertexX, int vertexY, ItemStack stack, int intU, int intV) {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            IBakedModel iBakedModel = mc.func_175599_af().func_175037_a().func_178089_a(stack);
            TextureAtlasSprite textureAtlasSprite = mc.func_147117_R().func_110572_b(iBakedModel.func_177554_e().func_195668_m().toString());
            mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)vertexX, (double)(vertexY + intV), 0.0).func_187315_a((double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b((double)(vertexX + intU), (double)(vertexY + intV), 0.0).func_187315_a((double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b((double)(vertexX + intU), (double)vertexY, 0.0).func_187315_a((double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b((double)vertexX, (double)vertexY, 0.0).func_187315_a((double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

