/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.advacements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class DropLvlPenaltyTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("mmorpg", "drop_lvl_penalty_trigger");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners LevelTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (LevelTrigger$listeners == null) {
            LevelTrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, LevelTrigger$listeners);
        }
        LevelTrigger$listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners LevelTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (LevelTrigger$listeners != null) {
            LevelTrigger$listeners.remove(listener);
            if (LevelTrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        int level = json.get("level").getAsInt();
        return new Instance(level);
    }

    public void trigger(ServerPlayerEntity player, EntityCap.UnitData data, EntityCap.UnitData mob) {
        Listeners LevelTrigger$listeners = this.listeners.get(player.func_192039_O());
        if (LevelTrigger$listeners != null) {
            LevelTrigger$listeners.trigger(data, mob);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(EntityCap.UnitData player, EntityCap.UnitData mob) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).conditionIsMet(player, mob)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        public int level;

        public Instance(int level) {
            super(ID);
            this.level = level;
        }

        public boolean conditionIsMet(EntityCap.UnitData player, EntityCap.UnitData mob) {
            int diff = MathHelper.func_76130_a((int)(player.getLevel() - mob.getLevel()));
            return diff >= this.level;
        }

        public JsonElement func_200288_b() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("level", (JsonElement)new JsonPrimitive((Number)this.level));
            return jsonobject;
        }
    }
}

