/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.egg_loot_crate;

import com.robertx22.mine_and_slash.blocks.conditions.IConditionalLootCrate;
import com.robertx22.mine_and_slash.blocks.conditions.LootCrateCondition;
import com.robertx22.mine_and_slash.blocks.conditions.NoMobAroundCondition;
import com.robertx22.mine_and_slash.database.rarities.gears.MythicalGear;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.MasterLootGen;
import com.robertx22.mine_and_slash.mmorpg.registers.common.BlockRegister;
import com.robertx22.mine_and_slash.saveclasses.PlayerOncePerMapData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.datasaving.PlayerOncePerMap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ElementalParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class EggLootCrateTileEntity
extends TileEntity
implements ITickableTileEntity,
IConditionalLootCrate {
    public static final String dataLoc = "PlayerOncePerMapData";
    public static final String isdroppingloc = "isdroppingloc";
    public static final String droplootticksloc = "droplootticksloc";
    public static final String timestodroploc = "timesToDrop";
    PlayerOncePerMapData data = new PlayerOncePerMapData();
    PlayerEntity player;
    int timesToDrop = this.getTimesToDrop();
    public boolean isDroppingLoot = false;
    int dropLootTicks = 0;

    public EggLootCrateTileEntity() {
        super(BlockRegister.EGG_LOOT_CRATE);
    }

    public void firework() {
        FireworkRocketEntity firework = new FireworkRocketEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p(), ItemStack.field_190927_a);
        firework.func_70107_b((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p());
        firework.func_184224_h(true);
        WorldUtils.spawnEntity(this.field_145850_b, (Entity)firework);
    }

    public void dropLoot(PlayerEntity player) {
        --this.timesToDrop;
        if (player != null) {
            List<ItemStack> loot = MasterLootGen.generateLoot(new LootInfo(player).setMinimum(1));
            for (ItemStack stack : loot) {
                WorldUtils.spawnEntity(this.field_145850_b, (Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), stack));
            }
            if (loot.size() > 0) {
                this.firework();
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        CompoundNBT datanbt = new CompoundNBT();
        PlayerOncePerMap.Save(datanbt, this.data);
        nbt.func_218657_a(dataLoc, (INBT)datanbt);
        nbt.func_74768_a(timestodroploc, this.timesToDrop);
        nbt.func_74757_a(isdroppingloc, this.isDroppingLoot);
        nbt.func_74768_a(droplootticksloc, this.dropLootTicks);
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.data = PlayerOncePerMap.Load(nbt.func_74775_l(dataLoc));
        if (this.data == null) {
            this.data = new PlayerOncePerMapData();
        }
        this.timesToDrop = nbt.func_74762_e(timestodroploc);
        this.isDroppingLoot = nbt.func_74767_n(isdroppingloc);
        this.dropLootTicks = nbt.func_74762_e(droplootticksloc);
    }

    public void activateDrops(PlayerEntity player) {
        this.data.add(player);
        this.player = player;
        this.isDroppingLoot = true;
        this.timesToDrop = this.getTimesToDrop();
    }

    public int getTimesToDrop() {
        return 5;
    }

    public void reset() {
        this.isDroppingLoot = false;
        this.timesToDrop = this.getTimesToDrop();
    }

    public boolean finished() {
        return this.timesToDrop < 1;
    }

    private Rarity getRarity() {
        return new MythicalGear();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isDroppingLoot) {
            if (this.finished()) {
                this.reset();
            }
            ElementalParticleUtils.SpawnAoeParticle(this.getRarity(), this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1.3f, 10);
            ++this.dropLootTicks;
            if (this.timesToDrop > 0 && this.dropLootTicks > 20) {
                this.dropLootTicks = 0;
                this.dropLoot(this.player);
            }
        }
    }

    public void tryActivate(PlayerEntity player) {
        if (this.data == null) {
            this.data = new PlayerOncePerMapData();
        }
        if (this.condition().canOpenCrate(player)) {
            if (this.data.canDo(player)) {
                if (this.isDroppingLoot) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("This crate is currently being used."));
                } else {
                    this.activateDrops(player);
                }
            } else {
                player.func_145747_a((ITextComponent)new StringTextComponent("You have already used this block. Come again next map!"));
            }
        } else {
            player.func_145747_a(this.condition().tellCondition());
        }
    }

    @Override
    public LootCrateCondition condition() {
        return new NoMobAroundCondition(4);
    }
}

