/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.gear_factory_station;

import com.robertx22.mine_and_slash.blocks.bases.BaseTile;
import com.robertx22.mine_and_slash.blocks.gear_factory_station.ContainerGearFactory;
import com.robertx22.mine_and_slash.blocks.slots.FuelSlot;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RuneBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.SpellBlueprint;
import com.robertx22.mine_and_slash.loot.gens.GearLootGen;
import com.robertx22.mine_and_slash.loot.gens.RuneLootGen;
import com.robertx22.mine_and_slash.loot.gens.SpellLootGen;
import com.robertx22.mine_and_slash.mmorpg.registers.common.BlockRegister;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RuneItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.SpellItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.datasaving.Rune;
import com.robertx22.mine_and_slash.uncommon.datasaving.Spell;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class TileGearFactory
extends BaseTile {
    private static final int pointsNeeded = 2500;
    private static final int maxFuel = 25000;
    public static final int FUEL_SLOTS_COUNT = 1;
    public static final int INPUT_SLOTS_COUNT = 5;
    public static final int OUTPUT_SLOTS_COUNT = 5;
    public static final int TOTAL_SLOTS_COUNT = 12;
    public static final int FIRST_FUEL_SLOT = 0;
    public static final int FIRST_INPUT_SLOT = 1;
    public static final int FIRST_OUTPUT_SLOT = 6;
    public static final int FIRST_CAPACITOR_SLOT = 11;
    private static final short COOK_TIME_FOR_COMPLETION = 200;

    @Override
    public boolean isAutomatable() {
        return false;
    }

    @Override
    public boolean isItemValidInput(ItemStack stack) {
        return TileGearFactory.GetFuelGain(stack) > 0;
    }

    public static int GetFuelGain(ItemStack stack) {
        Item item = stack.func_77973_b();
        ItemOre.ItemOres.get(0);
        return FuelSlot.FUEL_VALUES.getOrDefault(item, 0);
    }

    public ItemStack getSmeltingResultForItem(ItemStack stack) {
        ItemStack result = ItemStack.field_190927_a;
        if (this.fuel > 2500) {
            result = this.getGearResult(stack);
            if (result.func_190926_b()) {
                result = this.getSpellResult(stack);
            }
            if (result.func_190926_b()) {
                result = this.getRuneResult(stack);
            }
        }
        return result;
    }

    private ItemStack getGearResult(ItemStack stack) {
        GearItemData data = Gear.Load(stack);
        if (data != null) {
            GearBlueprint print = new GearBlueprint(data.level);
            print.LevelRange = false;
            print.maxRarity = this.getMaxRarity(data.Rarity);
            if (RandomUtils.roll(50)) {
                print.SetSpecificType(data.gearTypeName);
            }
            return GearLootGen.CreateStack(print);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getSpellResult(ItemStack stack) {
        SpellItemData spell = Spell.Load(stack);
        if (spell != null) {
            SpellBlueprint print = new SpellBlueprint(spell.level);
            print.LevelRange = false;
            print.maxRarity = this.getMaxRarity(spell.rarity);
            if (RandomUtils.roll(50)) {
                print.SetSpecificType(spell.spellGUID);
            }
            return SpellLootGen.Create(print);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getRuneResult(ItemStack stack) {
        RuneItemData rune = Rune.Load(stack);
        if (rune != null) {
            RuneBlueprint print = new RuneBlueprint(rune.level);
            print.LevelRange = false;
            print.maxRarity = this.getMaxRarity(rune.rarity);
            if (RandomUtils.roll(50)) {
                print.SetSpecificType(rune.name);
            }
            return RuneLootGen.Create(print);
        }
        return ItemStack.field_190927_a;
    }

    private int getMaxRarity(int rar) {
        return rar + 3;
    }

    public TileGearFactory() {
        super(BlockRegister.GEAR_FACTORY);
        this.itemStacks = new ItemStack[12];
        this.func_174888_l();
    }

    public double fractionOfFuelRemaining(int fuelSlot) {
        if (this.fuel <= 0) {
            return 0.0;
        }
        double fraction = (double)this.fuel / 25000.0;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    @Override
    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / 200.0;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    @Override
    public int ticksRequired() {
        return 200;
    }

    @Override
    public void finishCooking() {
        this.smeltItem();
    }

    @Override
    public boolean isCooking() {
        return this.canSmelt();
    }

    @Override
    public int tickRate() {
        return 10;
    }

    @Override
    public void doActionEveryTime() {
        this.burnFuel();
    }

    @Override
    public int getCookTime() {
        return 200;
    }

    private int burnFuel() {
        int burningCount = 0;
        boolean inventoryChanged = false;
        for (int i = 0; i < 1; ++i) {
            int fuelSlotNumber = i + 0;
            if (this.fuel >= 25000 || this.itemStacks[fuelSlotNumber].func_190926_b()) continue;
            int fuel = TileGearFactory.GetFuelGain(this.itemStacks[fuelSlotNumber]);
            if (fuel > 0) {
                this.fuel += fuel;
            } else {
                return 0;
            }
            this.itemStacks[fuelSlotNumber].func_190918_g(1);
            ++burningCount;
            inventoryChanged = true;
            if (this.itemStacks[fuelSlotNumber].func_190916_E() != 0) continue;
            this.itemStacks[fuelSlotNumber] = this.itemStacks[fuelSlotNumber].func_77973_b().getContainerItem(this.itemStacks[fuelSlotNumber]);
        }
        if (inventoryChanged) {
            this.func_70296_d();
        }
        return burningCount;
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        Integer firstSuitableInputSlot = null;
        Integer firstSuitableOutputSlot = null;
        ItemStack result = ItemStack.field_190927_a;
        for (int inputSlot = 1; inputSlot < 6; ++inputSlot) {
            if (this.itemStacks[inputSlot].func_190926_b() || (result = 2500 < this.fuel ? this.getSmeltingResultForItem(this.itemStacks[inputSlot]) : ItemStack.field_190927_a).func_190926_b()) continue;
            for (int outputSlot = 6; outputSlot < 11; ++outputSlot) {
                int combinedSize;
                ItemStack outputStack = this.itemStacks[outputSlot];
                if (outputStack.func_190926_b()) {
                    firstSuitableInputSlot = inputSlot;
                    firstSuitableOutputSlot = outputSlot;
                    break;
                }
                if (outputStack.func_77973_b() != result.func_77973_b() || !ItemStack.func_77970_a((ItemStack)outputStack, (ItemStack)result) || (combinedSize = this.itemStacks[outputSlot].func_190916_E() + result.func_190916_E()) > this.func_70297_j_() || combinedSize > this.itemStacks[outputSlot].func_77976_d()) continue;
                firstSuitableInputSlot = inputSlot;
                firstSuitableOutputSlot = outputSlot;
                break;
            }
            if (firstSuitableInputSlot != null) break;
        }
        if (firstSuitableInputSlot == null) {
            return false;
        }
        if (!performSmelt) {
            return true;
        }
        this.itemStacks[firstSuitableInputSlot].func_190918_g(1);
        if (this.itemStacks[firstSuitableInputSlot].func_190916_E() <= 0) {
            this.itemStacks[firstSuitableInputSlot.intValue()] = ItemStack.field_190927_a;
        }
        if (this.itemStacks[firstSuitableOutputSlot].func_190926_b()) {
            this.itemStacks[firstSuitableOutputSlot.intValue()] = result.func_77946_l();
        } else {
            int newStackSize = this.itemStacks[firstSuitableOutputSlot].func_190916_E() + result.func_190916_E();
            this.itemStacks[firstSuitableOutputSlot].func_190920_e(newStackSize);
        }
        this.fuel -= 2500;
        this.func_70296_d();
        return true;
    }

    public ITextComponent func_145748_c_() {
        return CLOC.blank("block.mmorpg.gear_factory_station");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerGearFactory(i, playerInventory, (IInventory)this, this.field_174879_c);
    }
}

