/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.map_device;

import com.robertx22.mine_and_slash.blocks.bases.BaseTile;
import com.robertx22.mine_and_slash.blocks.map_device.ContainerMapDevice;
import com.robertx22.mine_and_slash.database.world_providers.IWP;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.items.misc.ItemMap;
import com.robertx22.mine_and_slash.mmorpg.registers.common.BlockRegister;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Map;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.DimensionType;

public class TileMapDevice
extends BaseTile {
    public static final int size = 4;

    @Override
    public boolean isAutomatable() {
        return false;
    }

    @Override
    public boolean isItemValidInput(ItemStack stack) {
        return false;
    }

    public ItemStack StartSlot() {
        return this.itemStacks[3];
    }

    public ItemStack TierSlot() {
        return this.itemStacks[0];
    }

    public ItemStack LevelSlot() {
        return this.itemStacks[1];
    }

    public ItemStack MapSlot() {
        return this.itemStacks[2];
    }

    public TileMapDevice() {
        super(BlockRegister.MAP_DEVICE);
        this.itemStacks = new ItemStack[4];
        this.func_174888_l();
    }

    @Override
    public int ticksRequired() {
        return 0;
    }

    @Override
    public void finishCooking() {
    }

    @Override
    public boolean isCooking() {
        return false;
    }

    @Override
    public int tickRate() {
        return 0;
    }

    @Override
    public void doActionEveryTime() {
    }

    @Override
    public int getCookTime() {
        return 0;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticks;
            if (this.ticks > 20) {
                this.ticks = 0;
                this.doLogic();
            }
        }
    }

    private void doLogic() {
        if (this.field_145850_b == null || this.field_145850_b.func_201675_m() == null || this.field_145850_b.func_201675_m() instanceof IWP) {
            return;
        }
        ItemStack start = this.StartSlot();
        MapItemData map = Map.Load(this.MapSlot());
        MapItemData level = Map.Load(this.LevelSlot());
        MapItemData tier = Map.Load(this.TierSlot());
        if (map != null) {
            if (level != null && map.increaseLevel(level.rarity + 1)) {
                this.LevelSlot().func_190918_g(1);
                Map.Save(this.MapSlot(), map);
            }
            if (tier != null && map.increaseTier(tier.rarity + 1)) {
                this.TierSlot().func_190918_g(1);
                Map.Save(this.MapSlot(), map);
            }
            if (start != null && start.func_77973_b().equals(Items.field_151014_N)) {
                BlockPos p = this.field_174879_c;
                PlayerEntity player = this.func_145831_w().func_190525_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 20.0, EntityPredicates.field_94557_a);
                if (player != null) {
                    this.field_145850_b.func_184148_a(null, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 0.6f, 0.0f);
                    this.field_145850_b.func_184148_a(null, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), SoundEvents.field_187812_eh, SoundCategory.BLOCKS, 0.4f, 0.0f);
                    try {
                        DimensionType type = MapManager.getDimensionType(map.getIWP().getResourceLoc());
                        MapItemData cloned = map.clone();
                        if (map.groupPlay) {
                            this.trySetupMapForGroup(cloned);
                        } else {
                            map.setupPlayerMapData(this.field_145850_b, p, player);
                        }
                        this.MapSlot().func_190918_g(1);
                        this.StartSlot().func_190918_g(1);
                        BlockPos pos = this.field_174879_c.func_177964_d(4);
                        Boolean spawnedPortal1 = ItemMap.createMapPortal(type, pos, this.field_145850_b, map);
                        BlockPos pos1 = this.field_174879_c.func_177970_e(4);
                        Boolean spawnedPortal2 = ItemMap.createMapPortal(type, pos1, this.field_145850_b, map);
                        BlockPos pos2 = this.field_174879_c.func_177965_g(4);
                        Boolean spawnedPortal3 = ItemMap.createMapPortal(type, pos2, this.field_145850_b, map);
                        BlockPos pos3 = this.field_174879_c.func_177985_f(4);
                        Boolean spawnedPortal4 = ItemMap.createMapPortal(type, pos3, this.field_145850_b, map);
                        if (!(spawnedPortal1.booleanValue() || spawnedPortal2.booleanValue() || spawnedPortal3.booleanValue() || spawnedPortal4.booleanValue())) {
                            AxisAlignedBB aab = new AxisAlignedBB(this.func_174877_v()).func_186662_g(10.0);
                            this.field_145850_b.func_217357_a(ServerPlayerEntity.class, aab).forEach(x -> x.func_145747_a(Chats.NoSpaceForPortal.locName()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.func_70296_d();
        }
    }

    private void trySetupMapForGroup(MapItemData map) {
        if (map.groupPlay) {
            AxisAlignedBB aab = new AxisAlignedBB(this.func_174877_v()).func_186662_g(10.0);
            List players = this.field_145850_b.func_217357_a(ServerPlayerEntity.class, aab);
            int added = 0;
            for (ServerPlayerEntity p : players) {
                if (added >= map.maxPlayersInGroup) continue;
                MapItemData cloned = map.clone();
                cloned.setupPlayerMapData(this.field_145850_b, this.field_174879_c, (PlayerEntity)p);
                ++added;
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return CLOC.blank("block.mmorpg.map_device");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerMapDevice(i, playerInventory, (IInventory)this);
    }
}

