/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.salvage_station;

import com.robertx22.mine_and_slash.blocks.bases.BaseTile;
import com.robertx22.mine_and_slash.blocks.salvage_station.ContainerGearSalvage;
import com.robertx22.mine_and_slash.items.misc.ItemCapacitor;
import com.robertx22.mine_and_slash.mmorpg.registers.common.BlockRegister;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISalvagable;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class TileGearSalvage
extends BaseTile {
    public static final int INPUT_SLOTS_COUNT = 5;
    public static final int OUTPUT_SLOTS_COUNT = 5;
    public static final int TOTAL_SLOTS_COUNT = 11;
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int FIRST_OUTPUT_SLOT = 5;
    public static final int FIRST_CAPACITOR_SLOT = 10;
    private static final short COOK_TIME_FOR_COMPLETION = 200;
    ItemStack result = ItemStack.field_190927_a;

    @Override
    public int[] inputSlots() {
        int[] ints = new int[5];
        for (int i = 0; i < 5; ++i) {
            ints[i] = i;
        }
        return ints;
    }

    @Override
    public int getCookTime() {
        ItemCapacitor cap = this.getCapacitor();
        if (cap != null) {
            return (int)(200.0f * cap.GetSpeedMultiplier().floatValue());
        }
        return 200;
    }

    public ItemCapacitor getCapacitor() {
        Item item;
        if (!this.itemStacks[10].func_190926_b() && (item = this.itemStacks[10].func_77973_b()) instanceof ItemCapacitor) {
            return (ItemCapacitor)item;
        }
        return null;
    }

    @Override
    public boolean isAutomatable() {
        return true;
    }

    private float getCapacitorBonus() {
        ItemStack stack = this.itemStacks[10];
        if (stack.func_77973_b() instanceof ItemCapacitor) {
            ItemCapacitor cap = (ItemCapacitor)stack.func_77973_b();
            return cap.getSalvageBonusChance().floatValue();
        }
        return 0.0f;
    }

    public ItemStack getSmeltingResultForItem(ItemStack st) {
        float bonus = this.getCapacitorBonus();
        ICommonDataItem data = ICommonDataItem.load(st);
        if (data != null && data.isSalvagable(ISalvagable.SalvageContext.SALVAGE_STATION)) {
            return data.getSalvageResult(bonus);
        }
        return ItemStack.field_190927_a;
    }

    public TileGearSalvage() {
        super(BlockRegister.GEAR_SALVAGE);
        this.itemStacks = new ItemStack[11];
        this.func_174888_l();
    }

    @Override
    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / (double)this.getCookTime();
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    @Override
    public int ticksRequired() {
        return this.getCookTime();
    }

    @Override
    public void finishCooking() {
        this.smeltItem();
    }

    @Override
    public boolean isCooking() {
        return this.canSmelt();
    }

    @Override
    public int tickRate() {
        return 10;
    }

    @Override
    public void doActionEveryTime() {
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        Integer firstSuitableInputSlot = null;
        Integer firstSuitableOutputSlot = null;
        for (int inputSlot = 0; inputSlot < 5; ++inputSlot) {
            if (this.itemStacks[inputSlot].func_190926_b()) continue;
            this.result = this.getSmeltingResultForItem(this.itemStacks[inputSlot]);
            if (this.result.func_190926_b()) continue;
            for (int outputSlot = 5; outputSlot < 10; ++outputSlot) {
                int combinedSize;
                ItemStack outputStack = this.itemStacks[outputSlot];
                if (outputStack.func_190926_b()) {
                    firstSuitableInputSlot = inputSlot;
                    firstSuitableOutputSlot = outputSlot;
                    break;
                }
                if (outputStack.func_77973_b() != this.result.func_77973_b() || !ItemStack.func_77970_a((ItemStack)outputStack, (ItemStack)this.result) || (combinedSize = this.itemStacks[outputSlot].func_190916_E() + this.result.func_190916_E()) > this.func_70297_j_() || combinedSize > this.itemStacks[outputSlot].func_77976_d()) continue;
                firstSuitableInputSlot = inputSlot;
                firstSuitableOutputSlot = outputSlot;
                break;
            }
            if (firstSuitableInputSlot != null) break;
        }
        if (firstSuitableInputSlot == null) {
            return false;
        }
        if (!performSmelt) {
            return true;
        }
        this.itemStacks[firstSuitableInputSlot].func_190918_g(1);
        if (this.itemStacks[firstSuitableInputSlot].func_190916_E() <= 0) {
            this.itemStacks[firstSuitableInputSlot.intValue()] = ItemStack.field_190927_a;
        }
        if (this.itemStacks[firstSuitableOutputSlot].func_190926_b()) {
            this.itemStacks[firstSuitableOutputSlot.intValue()] = this.result.func_77946_l();
            this.result = ItemStack.field_190927_a;
        } else {
            int newStackSize = this.itemStacks[firstSuitableOutputSlot].func_190916_E() + this.result.func_190916_E();
            this.itemStacks[firstSuitableOutputSlot].func_190920_e(newStackSize);
        }
        this.func_70296_d();
        return true;
    }

    @Override
    public boolean isItemValidInput(ItemStack stack) {
        ItemStack result = this.getSmeltingResultForItem(stack);
        return !result.func_190926_b();
    }

    public ITextComponent func_145748_c_() {
        return CLOC.blank("block.mmorpg.salvage_station");
    }

    @Nullable
    public Container createMenu(int num, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerGearSalvage(num, inventory, (IInventory)this, this.func_174877_v());
    }
}

