/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.robertx22.mine_and_slash.commands.bases.ItemModSuggestions;
import com.robertx22.mine_and_slash.database.item_modifications.bases.BaseItemModification;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ModifyItem {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"modifyItem").requires(e -> e.func_197034_c(2))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new ItemModSuggestions()).executes(e -> ModifyItem.run((CommandSource)e.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)e, (String)"target"), StringArgumentType.getString((CommandContext)e, (String)"type"))))));
    }

    private static int run(CommandSource commandSource, @Nullable PlayerEntity player, String word) {
        if (Objects.isNull(player)) {
            try {
                player = commandSource.func_197035_h();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return 1;
            }
        }
        try {
            ICommonDataItem data = ICommonDataItem.load(player.func_184614_ca());
            BaseItemModification mod = SlashRegistry.ItemModifications().get(word);
            if (mod.canModify(data)) {
                mod.modify(data);
                Gear.Save(player.func_184614_ca(), (GearItemData)data);
                player.func_145747_a(new StringTextComponent("Success! Added modification: ").func_150257_a(mod.locName()));
            } else {
                player.func_145747_a((ITextComponent)new StringTextComponent("Modification Failed, can't be done on this item."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}

