/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.base;

import net.minecraftforge.common.ForgeConfigSpec;

public class RarityWeight {
    public ForgeConfigSpec.IntValue COMMON_WEIGHT;
    public ForgeConfigSpec.IntValue UNCOMMON_WEIGHT;
    public ForgeConfigSpec.IntValue RARE_WEIGHT;
    public ForgeConfigSpec.IntValue EPIC_WEIGHT;
    public ForgeConfigSpec.IntValue LEGENDARY_WEIGHT;
    public ForgeConfigSpec.IntValue MYTHICAL_WEIGHT;

    public RarityWeight(String prefix, ForgeConfigSpec.Builder builder, DefaultConfig config) {
        builder.push(prefix);
        this.COMMON_WEIGHT = builder.translation("mmorpg.rarity.common").defineInRange("COMMON_WEIGHT", config.COMMON_WEIGHT, 0, Integer.MAX_VALUE);
        this.UNCOMMON_WEIGHT = builder.translation("mmorpg.rarity.uncommon").defineInRange("UNCOMMON_WEIGHT", config.UNCOMMON_WEIGHT, 0, Integer.MAX_VALUE);
        this.RARE_WEIGHT = builder.translation("mmorpg.rarity.rare").defineInRange("RARE_WEIGHT", config.RARE_WEIGHT, 0, Integer.MAX_VALUE);
        this.EPIC_WEIGHT = builder.translation("mmorpg.rarity.epic").defineInRange("EPIC_WEIGHT", config.EPIC_WEIGHT, 0, Integer.MAX_VALUE);
        this.LEGENDARY_WEIGHT = builder.translation("mmorpg.rarity.legendary").defineInRange("LEGENDARY_WEIGHT", config.LEGENDARY_WEIGHT, 0, Integer.MAX_VALUE);
        this.MYTHICAL_WEIGHT = builder.translation("mmorpg.rarity.mythical").defineInRange("MYTHICAL_WEIGHT", config.MYTHICAL_WEIGHT, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public static class DefaultConfig {
        public int COMMON_WEIGHT = 30000;
        public int UNCOMMON_WEIGHT = 20000;
        public int RARE_WEIGHT = 5000;
        public int EPIC_WEIGHT = 3000;
        public int LEGENDARY_WEIGHT = 1250;
        public int MYTHICAL_WEIGHT = 250;

        public DefaultConfig higherChanceByMulti(float multi) {
            float anti = 1.0f / multi;
            this.COMMON_WEIGHT = (int)((float)this.COMMON_WEIGHT * anti);
            this.UNCOMMON_WEIGHT = (int)((float)this.UNCOMMON_WEIGHT * anti);
            this.EPIC_WEIGHT = (int)((float)this.EPIC_WEIGHT * multi);
            this.LEGENDARY_WEIGHT = (int)((float)this.LEGENDARY_WEIGHT * multi);
            this.MYTHICAL_WEIGHT = (int)((float)this.MYTHICAL_WEIGHT * multi);
            return this;
        }
    }
}

