/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.compatible_items;

import com.robertx22.mine_and_slash.config.compatible_items.WeightedType;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.items.unique_items.IUnique;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RunedGearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.UniqueGearBlueprint;
import com.robertx22.mine_and_slash.loot.gens.GearLootGen;
import com.robertx22.mine_and_slash.loot.gens.RunedGearLootGen;
import com.robertx22.mine_and_slash.loot.gens.UniqueGearLootGen;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class ConfigItem
implements IWeighted,
ISlashRegistryEntry {
    public transient String registryName = "";
    public String itemType = "Sword";
    public boolean isSalvagable = false;
    public int dropWeight = 1000;
    public int uniqueItemWeight = 0;
    public int normalItemWeight = 80;
    public int runedItemWeight = 20;
    public int randomUniqueUpToTier = 10;
    public int minRarity = 0;
    public int maxRarity = 5;
    public int levelVariance = 0;
    public String uniqueId = "";
    public boolean uniqueIsRandom = true;
    public int minLevel = 1;
    public int maxLevel = 100;
    public boolean statsAddedOnlyOnDrop = false;
    public boolean dropsAsLoot = true;

    @Override
    public int Weight() {
        return this.dropWeight;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.COMPATIBLE_ITEM;
    }

    @Override
    public String GUID() {
        return this.registryName;
    }

    @Override
    public int getRarityRank() {
        return 0;
    }

    public Rarity getRarity() {
        return Rarities.Items.get(this.getRarityRank());
    }

    @Override
    public int Tier() {
        return 0;
    }

    public ConfigItem setUniqueId(IUnique uniq) {
        this.uniqueId = uniq.GUID();
        this.uniqueIsRandom = false;
        return this;
    }

    public ConfigItem setMaxUniqueTier(int tier) {
        this.randomUniqueUpToTier = tier;
        return this;
    }

    public ConfigItem setGenerationWeights(int normalItemWeight, int runedItemWeight, int uniqueItemWeight) {
        this.normalItemWeight = normalItemWeight;
        this.uniqueItemWeight = uniqueItemWeight;
        this.runedItemWeight = runedItemWeight;
        return this;
    }

    public ConfigItem setAlwaysNormal() {
        this.normalItemWeight = 1;
        this.uniqueItemWeight = 0;
        this.runedItemWeight = 0;
        return this;
    }

    public ConfigItem setAlwaysRuned() {
        this.normalItemWeight = 0;
        this.uniqueItemWeight = 0;
        this.runedItemWeight = 1;
        return this;
    }

    public ConfigItem setAlwaysUnique() {
        this.normalItemWeight = 0;
        this.uniqueItemWeight = 1;
        this.runedItemWeight = 0;
        return this;
    }

    public ConfigItem setType(GearItemSlot type) {
        this.itemType = type.GUID();
        return this;
    }

    public ConfigItem setType(String type) {
        this.itemType = type;
        return this;
    }

    public ConfigItem setDropWeight(int weight) {
        this.dropWeight = weight;
        return this;
    }

    public ConfigItem setMinRarity(int rar) {
        this.minRarity = rar;
        return this;
    }

    public ConfigItem setSalvagable(boolean bool) {
        this.isSalvagable = bool;
        return this;
    }

    public ConfigItem setMaxRarity(int rar) {
        this.maxRarity = rar;
        return this;
    }

    public ConfigItem setstatsAddedOnlyOnDrop(boolean bool) {
        this.statsAddedOnlyOnDrop = bool;
        return this;
    }

    public ConfigItem setdropsAsLoot(boolean bool) {
        this.dropsAsLoot = bool;
        return this;
    }

    public ConfigItem setMinLevel(int rar) {
        this.minLevel = rar;
        return this;
    }

    public ConfigItem setMaxLevel(int rar) {
        this.maxLevel = rar;
        return this;
    }

    public boolean isValid() throws Exception {
        if (!this.uniqueIsRandom && !SlashRegistry.UniqueGears().isRegistered(this.uniqueId)) {
            throw new Exception("Unique Id doesn't exist: " + this.uniqueId);
        }
        boolean matchtype = false;
        for (GearItemSlot slot : SlashRegistry.GearTypes().getAll().values()) {
            if (!slot.GUID().equals(this.itemType)) continue;
            matchtype = true;
        }
        if (!matchtype) {
            throw new Exception("Gear Type doesn't exist: " + this.itemType);
        }
        if (this.normalItemWeight < 1 && this.runedItemWeight < 1 && this.uniqueItemWeight < 1) {
            throw new Exception("Weights can't all be 0 on an item: ");
        }
        return true;
    }

    public ItemStack create(ItemStack stack, int level) {
        level = this.getLevel(level);
        switch (this.getCreationType()) {
            case NORMAL: {
                this.createNormal(stack, level);
                break;
            }
            case UNIQUE: {
                this.createUnique(stack, level);
                break;
            }
            case RUNED: {
                this.createRuned(stack, level);
            }
        }
        return stack;
    }

    private creationTypes getCreationType() {
        WeightedType result = RandomUtils.weightedRandom(Arrays.asList(new WeightedType(this.normalItemWeight, creationTypes.NORMAL), new WeightedType(this.uniqueItemWeight, creationTypes.UNIQUE), new WeightedType(this.runedItemWeight, creationTypes.RUNED)));
        return result.type;
    }

    private int getLevel(int playerlevel) {
        return MathHelper.func_76125_a((int)playerlevel, (int)this.minLevel, (int)this.maxLevel);
    }

    private ItemStack createNormal(ItemStack stack, int level) {
        GearBlueprint blueprint = new GearBlueprint(level);
        blueprint.SetSpecificType(this.itemType);
        blueprint.LevelRange = this.levelVariance > 0;
        blueprint.LevelVariance = this.levelVariance;
        blueprint.minRarity = this.minRarity;
        blueprint.maxRarity = this.maxRarity;
        GearItemData gear = GearLootGen.CreateData(blueprint);
        gear.isSalvagable = this.isSalvagable;
        gear.isNotFromMyMod = true;
        Gear.Save(stack, gear);
        return stack;
    }

    private ItemStack createUnique(ItemStack stack, int level) {
        UniqueGearBlueprint blueprint = new UniqueGearBlueprint(level, this.uniqueId);
        blueprint.uniqueIsRandom = this.uniqueIsRandom;
        blueprint.tier = this.randomUniqueUpToTier;
        blueprint.map_tier = this.randomUniqueUpToTier;
        blueprint.SetSpecificType(this.itemType);
        blueprint.LevelRange = this.levelVariance > 0;
        blueprint.LevelVariance = this.levelVariance;
        GearItemData gear = UniqueGearLootGen.CreateData(blueprint);
        gear.isSalvagable = this.isSalvagable;
        gear.isNotFromMyMod = true;
        if (gear.uniqueGUID == null || !SlashRegistry.UniqueGears().isRegistered(gear.uniqueGUID)) {
            return this.createNormal(stack, level);
        }
        Gear.Save(stack, gear);
        return stack;
    }

    private ItemStack createRuned(ItemStack stack, int level) {
        RunedGearBlueprint blueprint = new RunedGearBlueprint(level);
        blueprint.SetSpecificType(this.itemType);
        blueprint.LevelRange = this.levelVariance > 0;
        blueprint.LevelVariance = this.levelVariance;
        blueprint.minRarity = this.minRarity;
        blueprint.maxRarity = this.maxRarity;
        GearItemData gear = RunedGearLootGen.CreateData(blueprint);
        gear.isSalvagable = this.isSalvagable;
        gear.isNotFromMyMod = true;
        Gear.Save(stack, gear);
        return stack;
    }

    public static enum creationTypes {
        NORMAL,
        RUNED,
        UNIQUE;

    }
}

