/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.compatible_items;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.robertx22.mine_and_slash.config.base.ISerializedConfig;
import com.robertx22.mine_and_slash.config.compatible_items.ConfigItems;
import com.robertx22.mine_and_slash.config.compatible_items.GenCompItemJsons;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SerializationUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConfigItemsSerialization
implements ISerializedConfig {
    public static ConfigItemsSerialization INSTANCE = new ConfigItemsSerialization();

    @Override
    public void generateIfEmpty() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)GenCompItemJsons.generate());
        SerializationUtils.makeFileAndDirAndWrite(this.folder(), this.fileName(), json);
    }

    @Override
    public String fileName() {
        return "CompatibleItems.txt";
    }

    @Override
    public String folder() {
        return SerializationUtils.CONFIG_PATH + "compatible_items/";
    }

    @Override
    public void load() {
        for (File file : Objects.requireNonNull(new File(this.folder()).listFiles())) {
            try {
                JsonReader reader = new JsonReader((Reader)new FileReader(file.getPath()));
                ConfigItems items = (ConfigItems)new Gson().fromJson(reader, ConfigItems.class);
                items.validateAll();
                items.registerAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Items added to config: " + SlashRegistry.CompatibleItems().getSize());
    }

    public void generateConfigTutorials() {
        this.genListOfUniqueItems();
        this.genListOfItemTypes();
    }

    private void genListOfUniqueItems() {
        String text = "// THIS FILE IS A TUTORIAL FILE, IT LETS YOU KNOW THE GUIDS/IDS OF ALL UNIQUE ITEMS\n" + String.join((CharSequence)"\n", SlashRegistry.UniqueGears().getList().stream().map(x -> x.GUID()).collect(Collectors.toList()));
        SerializationUtils.makeFileAndDirAndWrite("tutorials", "UniqueItemGUIDS-TUTORIAL.txt", text);
    }

    private void genListOfItemTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (GearItemSlot item : SlashRegistry.GearTypes().getAll().values()) {
            list.add(item.GUID());
        }
        String text = "// THIS FILE IS A TUTORIAL FILE, IT LETS YOU KNOW WHAT ITEM TYPES THERE ARE\n" + String.join((CharSequence)"\n", list);
        SerializationUtils.makeFileAndDirAndWrite("tutorials", "GearTypeGUIDS-TUTORIAL.txt", text);
    }
}

