/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.compatible_items.auto_gen;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraftforge.registries.ForgeRegistries;

public class AvgMat {
    private static void add(HashSet<IArmorMaterial> list, IArmorMaterial mat) {
        if (mat.getClass().isEnum() || !list.stream().anyMatch(x -> x.getClass().equals(mat.getClass()))) {
            list.add(mat);
        }
    }

    public static ArmorValues getValues(IArmorMaterial mat) {
        ArmorValues val = new ArmorValues();
        EquipmentSlotType slot = EquipmentSlotType.CHEST;
        val.reduct = mat.func_200902_b(slot);
        val.tough = mat.func_200896_a(slot);
        val.ench = mat.func_200900_a();
        val.dur = mat.func_200896_a(slot);
        return val;
    }

    public static ArmorValues GetAvgArmorValues() {
        ArmorValues val = new ArmorValues();
        HashSet mats = new HashSet();
        ForgeRegistries.ITEMS.getValues().stream().filter(x -> x instanceof ArmorItem).forEach(x -> AvgMat.add(mats, ((ArmorItem)x).func_200880_d()));
        List all = mats.stream().map(x -> AvgMat.getValues(x)).collect(Collectors.toList());
        val.dur = (float)(all.stream().mapToDouble(x -> x.dur).sum() / (double)mats.size());
        val.ench = (float)(all.stream().mapToDouble(x -> x.ench).sum() / (double)mats.size());
        val.tough = (float)(all.stream().mapToDouble(x -> x.tough).sum() / (double)mats.size());
        val.reduct = (float)(all.stream().mapToDouble(x -> x.reduct).sum() / (double)mats.size());
        return val;
    }

    public static class ArmorValues {
        public float dur = 0.0f;
        public float ench = 0.0f;
        public float tough = 0.0f;
        public float reduct = 0.0f;

        public float getSum() {
            return this.dur + this.ench + this.tough + this.reduct;
        }

        public float getBreakpoint(ArmorValues best) {
            return this.getSum() / best.getSum();
        }
    }
}

