/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.dimension_configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.robertx22.mine_and_slash.config.base.ISerializedConfig;
import com.robertx22.mine_and_slash.config.dimension_configs.DimensionsContainer;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SerializationUtils;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;

public class ConfigDimensionsSerialization
implements ISerializedConfig {
    public static ConfigDimensionsSerialization INSTANCE = new ConfigDimensionsSerialization();

    @Override
    public String folder() {
        return SerializationUtils.CONFIG_PATH;
    }

    @Override
    public String fileName() {
        return "DimensionConfigs.txt";
    }

    @Override
    public void generateIfEmpty() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)new DimensionsContainer());
        SerializationUtils.makeFileAndDirAndWrite(this.folder(), this.fileName(), json);
    }

    @Override
    public void load() {
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(this.getPath()));
            DimensionsContainer dims = (DimensionsContainer)new Gson().fromJson(reader, DimensionsContainer.class);
            dims.registerAll();
            System.out.println("Dimensions added to config: " + dims.dimensionsList.size());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

