/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.gearitemslots.bases;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.AllTraitMods;
import com.robertx22.mine_and_slash.database.stats.mods.flat.ArmorFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.DodgeRatingFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.DexterityFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.IntelligenceFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.StaminaFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.StrengthFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.VitalityFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.WisdomFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.resources.ManaFlat;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Dexterity;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Intelligence;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Stamina;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Strength;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Vitality;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Wisdom;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public abstract class GearItemSlot
implements IWeighted,
IAutoLocName,
ISlashRegistryEntry<GearItemSlot> {
    public int cooldownTicks() {
        return 20;
    }

    public boolean isGearOfThisType(Item item) {
        return false;
    }

    public abstract String resourceID();

    public static List<StatMod> leatherArmorStats() {
        return Arrays.asList(new DodgeRatingFlat(), new DodgeRatingFlat(), new StaminaFlat(), new DexterityFlat());
    }

    public static List<StatMod> plateArmorStats() {
        return Arrays.asList(new ArmorFlat().multi(1.25f), new VitalityFlat(), new StrengthFlat());
    }

    public static List<StatMod> clothArmorStats() {
        return Arrays.asList(new ArmorFlat().multi(0.75f), new ManaFlat().multi(1.75f), new IntelligenceFlat(), new WisdomFlat());
    }

    public List<Stat> statRequirements() {
        return Arrays.asList(new Stat[0]);
    }

    public static List<Stat> plateRequirements() {
        return Arrays.asList(Strength.INSTANCE, Vitality.INSTANCE);
    }

    public static List<Stat> clothRequirements() {
        return Arrays.asList(Intelligence.INSTANCE, Wisdom.INSTANCE);
    }

    public static List<Stat> leatherRequirements() {
        return Arrays.asList(Dexterity.INSTANCE, Stamina.INSTANCE);
    }

    @Override
    public int getRarityRank() {
        return 0;
    }

    public Rarity getRarity() {
        return Rarities.Items.get(this.getRarityRank());
    }

    @Override
    public int Tier() {
        return 0;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.GEAR_TYPE;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Gear_Slots;
    }

    public abstract GearSlotType slotType();

    public List<StatMod> coreStatMods() {
        return Arrays.asList(new StrengthFlat(), new VitalityFlat(), new IntelligenceFlat(), new WisdomFlat(), new StaminaFlat(), new DexterityFlat());
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.gear_type." + this.formattedGUID();
    }

    public abstract List<StatMod> PrimaryStats();

    public abstract List<StatMod> PossibleSecondaryStats();

    public Item DefaultItem() {
        return Items.field_190931_a;
    }

    public abstract HashMap<Integer, Item> ItemsForRarities();

    @Override
    public int Weight() {
        return 1000;
    }

    public ItemStack GetStackForRarity(int rarityNum) {
        if (this.ItemsForRarities().containsKey(rarityNum)) {
            return new ItemStack((IItemProvider)this.ItemsForRarities().get(rarityNum));
        }
        return new ItemStack((IItemProvider)this.DefaultItem());
    }

    public Item GetItemForRarity(int rarityNum) {
        if (this.ItemsForRarities().containsKey(rarityNum)) {
            return this.ItemsForRarities().get(rarityNum);
        }
        return this.DefaultItem();
    }

    public List<StatMod> ChaosStats() {
        ArrayList<StatMod> list = new ArrayList<StatMod>();
        for (StatMod mod : SlashRegistry.StatMods().getAll().values()) {
            if (!(mod instanceof AllTraitMods)) continue;
            list.add(mod);
        }
        return list;
    }

    public static enum GearSlotType {
        Weapon,
        Armor,
        Jewerly,
        OffHand;

    }
}

