/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.currency;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.items.currency.IAddsInstability;
import com.robertx22.mine_and_slash.database.items.currency.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.items.ItemDefault;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.datasaving.ItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocMultiLore;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ITiered;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RegisterItemUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Tooltip;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class CurrencyItem
extends Item
implements IAddsInstability,
ISlashRegistryEntry<CurrencyItem>,
ICurrencyItemEffect,
IWeighted,
ITiered,
IAutoLocMultiLore,
IAutoLocDesc,
IAutoLocName {
    public ItemType itemTypesUsableOn = ItemType.GEAR;
    public static TextFormatting nameColor = TextFormatting.RED;

    @Override
    public abstract String GUID();

    public CurrencyItem(String name) {
        super(new ItemDefault().func_200917_a(64));
        RegisterItemUtils.RegisterItemName(this, name);
    }

    @Override
    public final boolean canItemBeModified(LocReqContext context) {
        if (!this.itemTypesUsableOn.isType(context.stack)) {
            return false;
        }
        for (BaseLocRequirement req : this.requirements()) {
            if (!req.isNotAllowed(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public String locDescLangFileGUID() {
        return this.getRegistryName().toString() + ".desc";
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locLoresGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CurrencyItem auto;
        if (this instanceof IAutoLocMultiLore) {
            auto = this;
            for (ITextComponent comp : auto.getComponents()) {
                tooltip.add(Styles.GREENCOMP().func_150258_a("'").func_150257_a(comp).func_150258_a("'"));
            }
        }
        if (this instanceof IAutoLocDesc) {
            auto = this;
            tooltip.add(Styles.YELLOWCOMP().func_150257_a(auto.locDesc()));
        }
        tooltip.add(ItemType.getTooltipString(this.itemTypesUsableOn));
        Tooltip.add("", tooltip);
        tooltip.add(TooltipUtils.tier(this.Tier()));
        tooltip.add(TooltipUtils.rarity(this.getRarity()));
        Tooltip.add("", tooltip);
        if (this instanceof IAddsInstability && ((Boolean)ModConfig.INSTANCE.Server.ENABLE_CURRENCY_ITEMS_INSTABILITY_SYSTEM.get()).booleanValue()) {
            tooltip.add(Styles.REDCOMP().func_150258_a("Adds " + this.instabilityAddAmount() + " Instability"));
        }
        Tooltip.add("", tooltip);
        Tooltip.add(Styles.BLUECOMP().func_150257_a(Words.Item_modifiable_in_station.locName()), tooltip);
        Tooltip.addEmpty(tooltip);
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.CURRENCY_ITEMS;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    public Rarity getRarity() {
        return Rarities.Items.get(this.getRarityRank());
    }

    @Override
    public int Weight() {
        if (this.getRarityRank() == 0) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.COMMON_WEIGHT.get();
        }
        if (this.getRarityRank() == 1) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.UNCOMMON_WEIGHT.get();
        }
        if (this.getRarityRank() == 2) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.RARE_WEIGHT.get();
        }
        if (this.getRarityRank() == 3) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.EPIC_WEIGHT.get();
        }
        if (this.getRarityRank() == 4) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.LEGENDARY_WEIGHT.get();
        }
        if (this.getRarityRank() == 5) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.MYTHICAL_WEIGHT.get();
        }
        return 0;
    }
}

