/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.items.currency;

import com.robertx22.mine_and_slash.database.items.currency.CurrencyItem;
import com.robertx22.mine_and_slash.database.items.currency.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.items.currency.ItemOrbOfTransmutation;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.items.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.items.profession.alchemy.bases.IHasRecipe;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.professions.recipe.SimpleRecipe;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public class ItemCheapGearLvl
extends CurrencyItem
implements ICurrencyItemEffect,
IHasRecipe {
    public static final String ID = "mmorpg:currency/cheap_gear_lvl";

    @Override
    public String GUID() {
        return "currency/cheap_gear_lvl";
    }

    public ItemCheapGearLvl() {
        super(ID);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        gear.setLevel(gear.getLevel() + 5);
        Gear.Save(stack, gear);
        return stack;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(SimpleGearLocReq.LEVEL_ISNT_HIGHER_THAN_MAX);
    }

    @Override
    public int Tier() {
        return 1;
    }

    @Override
    public int getRarityRank() {
        return 2;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Impatience breeds failure.");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Stone of Corruption";
    }

    @Override
    public String locDescForLangFile() {
        return "Increase Gears's lvl by 5";
    }

    @Override
    public int instabilityAddAmount() {
        return 250;
    }

    @Override
    public BaseRecipe getRecipe() {
        return SimpleRecipe.Builder.create(this.GUID(), Professions.TINKERERING).addMaterial(new ItemOrbOfTransmutation().getFromForgeRegistry(), 3).addMaterial(ItemOre.ItemOres.get(this.getRarityRank()), 3).addMaterial(Items.field_151044_h, 5).addMaterial(Items.field_151150_bK, 1).addMaterial(Items.field_151045_i, 1).buildMaterials().setOutput(this).levelReq(1).expGained(15).build();
    }
}

